/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.change;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@XmlType(name="Change")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class Change
implements Serializable {
    private static final long serialVersionUID = 20190625L;
    @Schema(example="sample@yukawa.de")
    private String user;
    @Schema(example="my example change")
    private String notes;
    private Date date;

    public Change() {
    }

    public Change(String user, Date date) {
        this.user = user;
        this.date = date;
    }

    public Change(String user, long date) {
        this.user = user;
        this.date = new Date(date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Change{");
        sb.append("user='").append(this.user).append('\'');
        sb.append(", date=").append(this.date);
        if (this.notes != null) {
            sb.append(", notes=").append(this.notes);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Change change = (Change)o;
        return Objects.equals(this.user, change.user) && Objects.equals(this.notes, change.notes) && Objects.equals(this.date, change.date);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.notes, this.date);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }
}

