/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Objects;

@XmlType(name="ChainKey")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class ChainKey
implements Serializable {
    private static final long serialVersionUID = 20190625L;
    @NotEmpty
    private String module;
    @NotEmpty
    private String entity;
    @NotEmpty
    private String id;

    public ChainKey() {
    }

    public ChainKey(String module, String entity, String id) {
        this.module = module;
        this.entity = entity;
        this.id = id;
    }

    public ChainKey(String module, Object entity, String id) {
        this.module = module;
        this.entity = String.valueOf(entity);
        this.id = id;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainKey chainKey = (ChainKey)o;
        return Objects.equals(this.getModule(), chainKey.getModule()) && Objects.equals(this.getEntity(), chainKey.getEntity()) && Objects.equals(this.getId(), chainKey.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.module != null) {
            sb.append(", module='").append(this.module).append('\'');
        }
        if (this.entity != null) {
            sb.append(", entity='").append(this.entity).append('\'');
        }
        if (this.id != null) {
            sb.append(", id='").append(this.id).append('\'');
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }
}

