/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.file;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import inc.yukawa.chain.base.core.domain.access.AccessRights;
import inc.yukawa.chain.base.core.domain.access.Accessible;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.custom.CustomField;
import inc.yukawa.chain.base.core.domain.custom.Customized;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.file.FileType;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.info.Versioned;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;

@XmlRootElement(name="file-info")
@XmlType(name="FileInfo")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class FileInfo
implements Serializable,
Changed,
Created,
Versioned,
Keyed<String>,
Accessible,
Customized {
    private static final long serialVersionUID = 1L;
    private String fileId;
    private String fileName;
    private Info info;
    private FileType type;
    private byte[] fileContent;
    private Long fileSize;
    private Long duration;
    private String parentId;
    private String mime;
    private String language;
    private Info author;
    private Change change;
    private Change created;
    private AccessRights accessRights;
    private List<String> tags;
    private List<CustomField> customFields;
    private Integer version;

    public FileInfo() {
    }

    public FileInfo(String fileId) {
        this.fileId = fileId;
    }

    @Override
    public String key() {
        return this.fileId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public FileType getType() {
        return this.type;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public byte[] getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(byte[] fileContent) {
        this.fileContent = fileContent;
    }

    public Long getFileSize() {
        if (this.fileContent != null) {
            return this.fileContent.length;
        }
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Info getAuthor() {
        return this.author;
    }

    public void setAuthor(Info author) {
        this.author = author;
    }

    @Override
    public Change getChange() {
        return this.change;
    }

    @Override
    public void setChange(Change change) {
        this.change = change;
    }

    @Override
    public Change getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Change created) {
        this.created = created;
    }

    @Override
    public AccessRights getAccessRights() {
        return this.accessRights;
    }

    @Override
    public void setAccessRights(AccessRights accessRights) {
        this.accessRights = accessRights;
    }

    @XmlElement(name="tag")
    @XmlElementWrapper(name="tags")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    @XmlElement(name="customField")
    @XmlElementWrapper(name="customFields")
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @Override
    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    public String toString() {
        return "FileInfo{fileId='" + this.fileId + "', fileName='" + this.fileName + "', info='" + this.info + "', type=" + this.type + ", fileSize=" + this.getFileSize() + ", duration='" + this.duration + "', parentId='" + this.parentId + "', mime='" + this.mime + "', language='" + this.language + "', author='" + this.author + "', change=" + this.change + ", created=" + this.created + ", accessRights=" + this.accessRights + ", tags=" + this.tags + ", customFields=" + this.customFields + ", version=" + this.version + "}";
    }
}

