/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.info;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.label.Label;
import inc.yukawa.chain.base.core.domain.module.CompInfo;
import inc.yukawa.chain.base.core.domain.person.Region;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Objects;

@XmlType(name="Info")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(subTypes={Region.class, Label.class, CompInfo.class})
public class Info
implements Serializable,
Keyed<String> {
    private static final long serialVersionUID = 20190429L;
    private String id;
    private String name;
    private String shortName;
    private String desc;

    public Info() {
    }

    public Info(String name, String shortName, String description) {
        this.name = name;
        this.shortName = shortName;
        this.desc = description;
    }

    public Info(Info info) {
        this(info.getName(), info.getShortName(), info.getDesc());
        this.id = info.getId();
    }

    @Override
    public String key() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        this.toStringFields(sb);
        sb.append('}');
        return sb.toString();
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.name != null) {
            sb.append("name='").append(this.name).append('\'');
        }
        if (this.id != null) {
            sb.append(", id='").append(this.id).append('\'');
        }
        if (this.shortName != null) {
            sb.append(", shortName='").append(this.shortName).append('\'');
        }
        if (this.desc != null) {
            sb.append(", desc='").append(this.desc).append('\'');
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info info = (Info)o;
        return Objects.equals(this.getId(), info.getId()) && Objects.equals(this.getName(), info.getName()) && Objects.equals(this.getShortName(), info.getShortName()) && Objects.equals(this.getDesc(), info.getDesc());
    }

    public int hashCode() {
        return this.id == null ? Objects.hash(this.getName(), this.getShortName(), this.getDesc()) : this.id.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

