/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.media;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.media.File;
import inc.yukawa.chain.base.core.domain.media.Image;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

@Schema(subTypes={Image.class, File.class})
public abstract class MediaBase
implements Serializable,
Created,
Changed,
Keyed<Integer> {
    protected String mime;
    protected String category;
    @Schema(description="could be used as index in collection of images")
    protected Integer position;
    @Schema(description="related object")
    protected ChainKey related;
    protected Info info;
    protected Change created;
    protected Change change;

    @Override
    public abstract Integer key();

    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public ChainKey getRelated() {
        return this.related;
    }

    public void setRelated(ChainKey related) {
        this.related = related;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    @Override
    public Change getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Change created) {
        this.created = created;
    }

    @Override
    public Change getChange() {
        return this.change;
    }

    @Override
    public void setChange(Change change) {
        this.change = change;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        return this.key() != null && this.key().equals(file.key());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.mime != null) {
            sb.append(", mime='").append(this.mime).append('\'');
        }
        if (this.category != null) {
            sb.append(", category='").append(this.category).append('\'');
        }
        if (this.position != null) {
            sb.append(", position='").append(this.position).append('\'');
        }
        if (this.related != null) {
            sb.append(", related='").append(this.related).append('\'');
        }
        if (this.info != null) {
            sb.append(", info='").append(this.info).append('\'');
        }
        if (this.created != null) {
            sb.append(", created='").append(this.created).append('\'');
        }
        if (this.change != null) {
            sb.append(", change='").append(this.change).append('\'');
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }
}

