/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.person;

import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.person.Address;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="person")
@XmlType(name="Person")
@Schema
public class Person
implements Serializable,
Changed,
Created {
    private static final long serialVersionUID = 1L;
    private String salutation;
    private String firstName;
    private String lastName;
    private String companyName;
    private String shortName;
    private String email;
    private String phoneNumber;
    private String mobile;
    private String role;
    private String vatNumber;
    private String title;
    @Schema(title="language code")
    private String lang;
    private Change created;
    private Change change;
    private List<Address> addresses;

    public Person() {
    }

    public Person(String companyName, String email, String phoneNumber) {
        this.companyName = companyName;
        this.email = email;
        this.phoneNumber = phoneNumber;
    }

    public Person(String firstName, String lastName, String companyName, String shortName, String email, String phoneNumber, String mobile, String role, List<Address> addresses) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.companyName = companyName;
        this.shortName = shortName;
        this.email = email;
        this.phoneNumber = phoneNumber;
        this.mobile = mobile;
        this.addresses = addresses;
    }

    public Person(String firstName, String lastName, String companyName, String shortName, String email, String phoneNumber, String mobile, String role, List<Address> addresses, String title) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.companyName = companyName;
        this.shortName = shortName;
        this.email = email;
        this.phoneNumber = phoneNumber;
        this.mobile = mobile;
        this.addresses = addresses;
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        this.toStringFields(sb);
        sb.append('}');
        return sb.toString().replaceFirst("\\{, ", "{");
    }

    protected StringBuilder toStringFields(StringBuilder sb) {
        if (this.created != null) {
            sb.append(", created=").append(this.created);
        }
        if (this.change != null) {
            sb.append(", change=").append(this.change);
        }
        if (this.salutation != null) {
            sb.append(", salutation='").append(this.salutation).append('\'');
        }
        if (this.firstName != null) {
            sb.append(", firstName='").append(this.firstName).append('\'');
        }
        if (this.lastName != null) {
            sb.append(", lastName='").append(this.lastName).append('\'');
        }
        if (this.companyName != null) {
            sb.append(", companyName='").append(this.companyName).append('\'');
        }
        if (this.shortName != null) {
            sb.append(", shortName='").append(this.shortName).append('\'');
        }
        if (this.email != null) {
            sb.append(", email='").append(this.email).append('\'');
        }
        if (this.phoneNumber != null) {
            sb.append(", phoneNumber='").append(this.phoneNumber).append('\'');
        }
        if (this.mobile != null) {
            sb.append(", mobile='").append(this.mobile).append('\'');
        }
        if (this.role != null) {
            sb.append(", role='").append(this.role).append('\'');
        }
        if (this.vatNumber != null) {
            sb.append(", vatNumber='").append(this.vatNumber).append('\'');
        }
        if (this.title != null) {
            sb.append(", title='").append(this.title).append('\'');
        }
        if (this.lang != null) {
            sb.append(", lang='").append(this.lang).append('\'');
        }
        if (this.addresses != null) {
            sb.append(", addresses=").append(this.addresses);
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person person = (Person)o;
        return Objects.equals(this.salutation, person.salutation) && Objects.equals(this.firstName, person.firstName) && Objects.equals(this.lastName, person.lastName) && Objects.equals(this.companyName, person.companyName) && Objects.equals(this.shortName, person.shortName) && Objects.equals(this.email, person.email) && Objects.equals(this.phoneNumber, person.phoneNumber) && Objects.equals(this.mobile, person.mobile) && Objects.equals(this.role, person.role) && Objects.equals(this.vatNumber, person.vatNumber) && Objects.equals(this.title, person.title) && Objects.equals(this.lang, person.lang) && Objects.equals(this.created, person.created) && Objects.equals(this.change, person.change) && Objects.equals(this.addresses, person.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.salutation, this.firstName, this.lastName, this.companyName, this.shortName, this.email, this.phoneNumber, this.mobile, this.role, this.vatNumber, this.title, this.lang, this.created, this.change, this.addresses);
    }

    public String getSalutation() {
        return this.salutation;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    @Override
    public Change getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Change created) {
        this.created = created;
    }

    @Override
    public Change getChange() {
        return this.change;
    }

    @Override
    public void setChange(Change change) {
        this.change = change;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @XmlElementWrapper(name="addresses", nillable=true)
    @XmlElement(name="address")
    @JsonProperty(value="addresses")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String language) {
        this.lang = language;
    }
}

