/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Map;

@Converter
public class MapJsonConverter
implements AttributeConverter<Map<String, Object>, String> {
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static ObjectMapper mapper = new ObjectMapper();

    public void setMapper(ObjectMapper mapper) {
        MapJsonConverter.mapper = mapper;
    }

    public String convertToDatabaseColumn(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, Object> convertToEntityAttribute(String val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        try {
            return (Map)mapper.readValue(val, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

