/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.custom;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.Info;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@XmlType(name="CustomField")
@Schema
public class CustomField
implements Serializable,
Changed,
Keyed<String> {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_TEXT_AREA = "textarea";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_DIGIT = "digit";
    public static final String TYPE_MONEY = "money";
    public static final String TYPE_PERCENT = "percent";
    public static final String TYPE_HREF = "href";
    public static final String TYPE_COLOR = "color";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_SELECT_ONE = "selectOne";
    public static final String TYPE_SELECT_MANY = "selectMany";
    private String id;
    private Info info;
    private String type;
    private String value;
    boolean required;
    private Change change;
    private String context;
    private boolean hidden;
    private boolean emitChangeEvent;
    @Schema(description="options for select type")
    private List<String> options;

    public CustomField() {
    }

    public CustomField(Info info, String type, String value, boolean required, Change change) {
        this.info = info;
        this.type = type;
        this.value = value;
        this.required = required;
        this.change = change;
    }

    public CustomField(String name, String type, String value, boolean required) {
        this.info = new Info(name, null, null);
        this.type = type;
        this.value = value;
        this.required = required;
    }

    @Override
    public String key() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomField)) {
            return false;
        }
        CustomField that = (CustomField)o;
        return this.required == that.required && this.hidden == that.hidden && this.emitChangeEvent == that.emitChangeEvent && this.id.equals(that.id) && Objects.equals(this.info, that.info) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.change, that.change) && Objects.equals(this.context, that.context) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.type, this.value, this.required, this.change, this.context, this.hidden, this.emitChangeEvent, this.options);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    @Override
    public Change getChange() {
        return this.change;
    }

    @Override
    public void setChange(Change change) {
        this.change = change;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isEmitChangeEvent() {
        return this.emitChangeEvent;
    }

    public void setEmitChangeEvent(boolean emitChangeEvent) {
        this.emitChangeEvent = emitChangeEvent;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.id != null) {
            sb.append(", id='").append(this.id).append('\'');
        }
        if (this.info != null) {
            sb.append(", info='").append(this.info).append('\'');
        }
        if (this.type != null) {
            sb.append(", type='").append(this.type).append('\'');
        }
        if (this.value != null) {
            sb.append(", value='").append(this.value).append('\'');
        }
        if (this.required) {
            sb.append(", required='").append(this.required).append('\'');
        }
        if (this.change != null) {
            sb.append(", change='").append(this.change).append('\'');
        }
        if (this.context != null) {
            sb.append(", context='").append(this.context).append('\'');
        }
        if (this.hidden) {
            sb.append(", hidden='").append(this.hidden).append('\'');
        }
        if (this.emitChangeEvent) {
            sb.append(", emitChangeEvent='").append(this.emitChangeEvent).append('\'');
        }
        if (this.options != null) {
            sb.append(", options='").append(this.options).append('\'');
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }
}

