/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.person;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.person.GeoLocation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Objects;

@XmlRootElement(name="address")
@XmlType(name="Address")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class Address
implements Serializable,
Keyed<String> {
    private static final long serialVersionUID = 421412415L;
    private String addressId;
    @Schema(description="used to distinguish addresses in list", example="main")
    private String type;
    private String street;
    private String houseNumber;
    private String zipCode;
    private String city;
    private String state;
    private String countryCode;
    private String region;
    private GeoLocation geoLocation;

    public Address() {
    }

    public Address(String street, String houseNumber, String city, String zipCode) {
        this.street = street;
        this.houseNumber = houseNumber;
        this.city = city;
        this.zipCode = zipCode;
    }

    @Override
    public String key() {
        return this.addressId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        this.toStringFields(sb);
        sb.append('}');
        return sb.toString().replaceFirst("\\{, ", "{");
    }

    protected StringBuilder toStringFields(StringBuilder sb) {
        if (this.addressId != null) {
            sb.append(", addressId='").append(this.addressId).append('\'');
        }
        if (this.type != null) {
            sb.append(", type='").append(this.type).append('\'');
        }
        if (this.street != null) {
            sb.append(", street='").append(this.street).append('\'');
        }
        if (this.houseNumber != null) {
            sb.append(", houseNumber='").append(this.houseNumber).append('\'');
        }
        if (this.zipCode != null) {
            sb.append(", zipCode='").append(this.zipCode).append('\'');
        }
        if (this.city != null) {
            sb.append(", city='").append(this.city).append('\'');
        }
        if (this.state != null) {
            sb.append(", state='").append(this.state).append('\'');
        }
        if (this.countryCode != null) {
            sb.append(", countryCode='").append(this.countryCode).append('\'');
        }
        if (this.geoLocation != null) {
            sb.append(", geoLocation=").append(this.geoLocation);
        }
        if (this.region != null) {
            sb.append(", region=").append(this.region);
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.addressId, address.addressId) && Objects.equals(this.type, address.type) && Objects.equals(this.street, address.street) && Objects.equals(this.houseNumber, address.houseNumber) && Objects.equals(this.zipCode, address.zipCode) && Objects.equals(this.city, address.city) && Objects.equals(this.state, address.state) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.region, address.region) && Objects.equals(this.geoLocation, address.geoLocation);
    }

    public int hashCode() {
        return Objects.hash(this.addressId, this.type, this.street, this.houseNumber, this.zipCode, this.city, this.state, this.countryCode, this.region, this.geoLocation);
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getAddressId() {
        return this.addressId;
    }

    public void setAddressId(String addressId) {
        this.addressId = addressId;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

