/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.core.domain.result.Result;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolation;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="AbstractResult")
@XmlSeeAlso(value={QueryResult.class, EditResult.class})
@Schema(subTypes={QueryResult.class, EditResult.class})
public abstract class AbstractResult
implements Serializable,
Result<ResultDetail> {
    private static final long serialVersionUID = 1L;
    @Schema(title="Fully qualified name of item", requiredMode=Schema.RequiredMode.REQUIRED, example="java.util.Date")
    protected String fqn;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="ping")
    private String operation;
    private List<ResultDetail> messages;
    private Date stamp = new Date();
    @Schema(title="How long the request took in ms")
    private Long took;

    public AbstractResult() {
    }

    protected AbstractResult(String operation, String fqn) {
        this.fqn = fqn;
        this.operation = operation;
    }

    protected AbstractResult(String operation, Class cls) {
        this(operation, cls.getName());
    }

    protected AbstractResult(String operation, String fqn, List<ResultDetail> messages, Date stamp, Long took) {
        this(operation, fqn);
        this.messages = messages;
        this.stamp = stamp;
        this.took = took;
    }

    protected AbstractResult(String operation, Class cls, List<ResultDetail> messages, Date stamp, Long took) {
        this(operation, cls.getName(), messages, stamp, took);
    }

    public void addMessage(ResultDetail detail) {
        if (this.messages == null) {
            this.messages = new ArrayList<ResultDetail>();
        }
        this.messages.add(detail);
    }

    public boolean addMessages(Collection<ResultDetail> details) {
        if (details != null && !details.isEmpty()) {
            if (this.messages == null) {
                this.messages = new ArrayList<ResultDetail>();
            }
            return this.messages.addAll(details);
        }
        return false;
    }

    public boolean merge(AbstractResult other) {
        boolean changed = false;
        if (this.operation == null && other.operation != null) {
            this.operation = other.operation;
            changed = true;
        }
        if (this.fqn == null && other.fqn != null) {
            this.fqn = other.fqn;
            changed = true;
        }
        if (other != null) {
            changed = changed || this.addMessages(other.getMessages());
        }
        return changed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringFields(new StringBuilder()) + "}";
    }

    protected StringBuilder toStringFields(StringBuilder sb) {
        sb.append(", fqn=").append(this.getFqn());
        if (this.operation != null) {
            sb.append(", op=").append(this.operation);
        }
        sb.append(", stamp=").append(this.stamp);
        if (this.messages != null) {
            sb.append(", messages=").append(this.messages);
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractResult)) {
            return false;
        }
        AbstractResult that = (AbstractResult)o;
        return Objects.equals(this.fqn, that.fqn) && Objects.equals(this.operation, that.operation) && Objects.equals(this.messages, that.messages) && Objects.equals(this.stamp, that.stamp) && Objects.equals(this.took, that.took);
    }

    public int hashCode() {
        return Objects.hash(this.fqn, this.operation, this.messages, this.stamp, this.took);
    }

    @Override
    @XmlElementWrapper(name="messages", nillable=true)
    @XmlElement(name="message")
    @JsonProperty(value="messages")
    public List<ResultDetail> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ResultDetail> messages) {
        this.messages = messages;
    }

    public ResultDetail findMessage(String type) {
        if (this.messages != null) {
            for (ResultDetail message : this.messages) {
                if (!type.matches(message.getType())) continue;
                return message;
            }
        }
        return null;
    }

    public ResultDetail findError() {
        return this.findMessage(3);
    }

    public int findMaxLevel() {
        ResultDetail max = this.findMaxDetail();
        return max != null ? max.getLevel() : -1;
    }

    public String findMaxText(String defaultText) {
        ResultDetail max = this.findMaxDetail();
        return max != null ? max.getText() : defaultText;
    }

    public ResultDetail findMaxDetail() {
        ResultDetail max = null;
        if (this.messages != null && !this.messages.isEmpty()) {
            max = this.messages.get(0);
            for (ResultDetail msg : this.messages) {
                if (msg.getLevel() < max.getLevel()) continue;
                max = msg;
            }
        }
        return max;
    }

    public String getLevelName(String defaultValue) {
        ResultDetail max = this.findMaxDetail();
        return max != null ? max.getLevelName() : defaultValue;
    }

    @XmlTransient
    @JsonIgnore
    public String getLevelName() {
        return this.getLevelName("info");
    }

    public ResultDetail findMessage(int minLevel) {
        if (this.messages != null) {
            for (ResultDetail message : this.messages) {
                if (message.getLevel() < minLevel) continue;
                return message;
            }
        }
        return null;
    }

    public <B> boolean addViolations(Set<ConstraintViolation<B>> violations) {
        return this.addViolations(violations, 3);
    }

    public <B> boolean addViolations(Set<ConstraintViolation<B>> violations, int level) {
        if (violations.isEmpty()) {
            return true;
        }
        AbstractResult edit = this;
        for (ConstraintViolation<B> vio : violations) {
            if (vio.getRootBeanClass() != null && edit.getFqn() == null) {
                edit.setFqn(vio.getRootBeanClass().getName());
            }
            this.addMessage(new ResultDetail(vio.getMessage(), "INVALID", "" + vio.getPropertyPath(), level));
        }
        return false;
    }

    @Override
    public boolean hasError() {
        return this.findError() != null;
    }

    @Override
    @XmlAttribute(name="op")
    @JsonProperty(value="op")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @XmlAttribute
    public String getFqn() {
        return this.fqn;
    }

    @JsonProperty(value="fqn")
    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @JsonIgnore
    public void setFqn(Class cls) {
        this.fqn = cls.getName();
    }

    @Override
    @XmlAttribute
    public Date getStamp() {
        return this.stamp;
    }

    public void setStamp(Date stamp) {
        this.stamp = stamp;
    }

    public Long getTook() {
        return this.took;
    }

    public void setTook(Long took) {
        this.took = took;
    }
}

