/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import inc.yukawa.chain.base.core.domain.result.AbstractResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="query-result")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="QueryResult")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"operation", "fqn", "stamp", "rows", "hasMore", "messages", "items"})
@Schema
public class QueryResult<E>
extends AbstractResult {
    private static final long serialVersionUID = 1L;
    @Schema(title="Found rows", requiredMode=Schema.RequiredMode.REQUIRED)
    private List<E> items;
    @Schema(title="Number of rows found", requiredMode=Schema.RequiredMode.REQUIRED)
    private Integer rows;
    @Schema(title="More rows available")
    private Boolean hasMore;

    public QueryResult() {
    }

    public QueryResult(String operation, String fqn, List<E> items, Integer rows, Boolean hasMore, List<ResultDetail> messages, Date stamp, Long took) {
        super(operation, fqn, messages, stamp, took);
        this.items = items;
        this.rows = rows;
        this.hasMore = hasMore;
    }

    public QueryResult(String operation, Class<E> cls, List<E> items, Integer rows, Boolean hasMore, List<ResultDetail> messages, Date stamp, Long took) {
        this(operation, cls.getName(), items, rows, hasMore, messages, stamp, took);
    }

    public QueryResult(String operation, String fqn) {
        super(operation, fqn);
    }

    public QueryResult(String operation, Class cls) {
        super(operation, cls);
    }

    public QueryResult(String operation, Class<E> cls, List<E> items) {
        this(operation, cls.getName(), items);
    }

    public QueryResult(String operation, String fqn, List<E> items) {
        super(operation, fqn);
        this.items = items;
        this.rows = items.size();
    }

    public QueryResult(Integer maxRows) {
        this.rows = maxRows;
    }

    public QueryResult(String operation, Integer rows) {
        super(operation, (String)null);
        this.rows = rows;
    }

    public QueryResult(List<E> rows) {
        this.items = rows;
        if (rows != null) {
            this.rows = this.items.size();
        }
    }

    public QueryResult(List<E> rows, int count, Boolean hasMore) {
        this.items = rows;
        this.rows = count;
        this.hasMore = hasMore;
    }

    public QueryResult(List<E> rows, int count) {
        this(rows, count, count > rows.size());
    }

    public <T> QueryResult<T> changeItems(String fqn, List<T> newItems) {
        return new QueryResult<T>(this.getOperation(), fqn, newItems, this.getRows(), this.getHasMore(), this.getMessages(), this.getStamp(), this.getTook());
    }

    public <T> QueryResult<T> changeItems(Class<T> cls, List<T> newItems) {
        return this.changeItems(cls.getName(), newItems);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryResult)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        return Objects.equals(this.items, that.items) && Objects.equals(this.rows, that.rows) && Objects.equals(this.hasMore, that.hasMore);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items, this.rows, this.hasMore);
    }

    @Override
    protected StringBuilder toStringFields(StringBuilder sb) {
        sb.append("items=").append(this.items != null ? Integer.valueOf(this.items.size()) : "null");
        sb.append(", rows=").append(this.rows);
        sb.append(", more=").append(this.hasMore);
        return super.toStringFields(sb);
    }

    @XmlElementWrapper(name="items", nillable=true)
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<E> getItems() {
        return this.items;
    }

    public void setItems(List<E> items) {
        this.items = items;
    }

    @XmlAttribute
    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    @XmlAttribute(name="more")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }
}

