/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.result.Detail;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ResultDetail")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class ResultDetail
implements Serializable,
Detail {
    private static final long serialVersionUID = 1L;
    public static final int LVL_DEBUG = 0;
    public static final int LVL_INFO = 1;
    public static final int LVL_WARNING = 2;
    public static final int LVL_ERROR = 3;
    public static final int LVL_FATAL = 30;
    public static final int LVL_MAX = 9999;
    public static final String CODE_OK = "OK";
    public static final String CODE_IO = "IO";
    public static final String CODE_VALID = "VALID";
    public static final String CODE_INVALID = "INVALID";
    public static final String CODE_DUPLICATE = "DUPLICATE";
    public static final String CODE_DATA_ACCESS = "DATA_ACCESS";
    public static final String CODE_NOT_FOUND = "NOT_FOUND";
    public static final String CODE_UNKNOWN = "UNKNOWN";
    public static final String CODE_DELETE = "DELETE";
    @Schema(title="Message Text", requiredMode=Schema.RequiredMode.REQUIRED, example="Swagger Message")
    @XmlValue
    @JsonProperty(value="text")
    private String text;
    @XmlAttribute
    @Schema(title="Error Code", example="ENV.COM")
    private String code;
    @XmlAttribute
    private String type;
    @XmlAttribute
    @Schema(title="Message Level", description="1=Info, 2=Warning, 3=Error", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"range[1, 5]"}, example="2")
    private int level;
    @XmlAttribute
    private final Date stamp = new Date();

    public ResultDetail() {
    }

    public ResultDetail(String text, String code, String type, int level) {
        this.text = text;
        this.code = code;
        this.type = type;
        this.level = level;
    }

    public String toString() {
        return "ResultDetail{code='" + this.code + "', text='" + this.text + "', type='" + this.type + "', level=" + this.level + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultDetail)) {
            return false;
        }
        ResultDetail that = (ResultDetail)o;
        return this.level == that.level && Objects.equals(this.text, that.text) && Objects.equals(this.code, that.code) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.code, this.type, this.level);
    }

    public static ResultDetail info(String text, int code, String type) {
        return ResultDetail.info(text, String.valueOf(code), type);
    }

    public static ResultDetail info(String text, String code, String type) {
        return new ResultDetail(text, code, type, 1);
    }

    public static ResultDetail ok(String text) {
        return new ResultDetail(text, CODE_OK, null, 1);
    }

    public static ResultDetail warn(String text, String code, String type) {
        return new ResultDetail(text, code, type, 2);
    }

    public static ResultDetail warn(String text, int code, String type) {
        return ResultDetail.warn(text, String.valueOf(code), type);
    }

    public static ResultDetail error(Object text, int code, String type) {
        return ResultDetail.error(text, String.valueOf(code), type);
    }

    public static ResultDetail error(Object text, String code, String type) {
        return new ResultDetail(String.valueOf(text), code, type, 3);
    }

    public static ResultDetail error(Object text, String code, Class<?> type) {
        return new ResultDetail(String.valueOf(text), code, type.getName(), 3);
    }

    public static ResultDetail error(Throwable error, String code) {
        return ResultDetail.error((Object)error.getMessage(), code, error.getClass().getName());
    }

    public static ResultDetail error(Throwable error) {
        return ResultDetail.error(error, CODE_UNKNOWN);
    }

    @XmlTransient
    @JsonIgnore
    public String getLevelName() {
        switch (this.level) {
            case 3: {
                return "error";
            }
            case 2: {
                return "warn";
            }
            case 1: {
                return "info";
            }
        }
        return "debug";
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

