/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="tree-node")
@XmlType(name="TreeNode")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class TreeNode<T extends Serializable>
implements Iterable<TreeNode<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected T data;
    protected TreeNode<T> parent;
    @NotNull
    protected List<TreeNode<T>> children = new LinkedList<TreeNode<T>>();

    public TreeNode() {
    }

    public TreeNode(T data) {
        this.data = data;
    }

    public void addChild(T child) {
        this.addChild(new TreeNode<T>(child));
    }

    public void addChild(TreeNode<T> childNode) {
        childNode.setParent(this);
        this.children.add(childNode);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @JsonIgnore
    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> children) {
        this.children = children;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.data != null) {
            sb.append(", data='").append(this.data).append('\'');
        }
        sb.append(", hasParent='").append(this.parent != null).append('\'');
        if (this.children != null) {
            sb.append(", childrenCount='").append(this.children.size()).append('\'');
        }
        return sb;
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        LinkedList<TreeNode<T>> all = new LinkedList<TreeNode<T>>(this.children);
        all.addFirst(this);
        return all.iterator();
    }
}

