/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.notification;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.notification.FileAttachment;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@XmlType(name="Notification")
@XmlRootElement(name="notification")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class Notification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CHANNEL_EMAIL = "EMAIL";
    public static final String CHANNEL_PUSH = "PUSH";
    public static final String CHANNEL_SMS = "SMS";
    public static final String CHANNEL_WHATSAPP = "WHATSAPP";
    public static final String CHANNEL_LOG = "LOG";
    public static final String RECIPIENT_TYPE_EMAIL = "EMAIL";
    public static final String RECIPIENT_TYPE_PHONE = "PHONE";
    public static final String RECIPIENT_TYPE_USERNAME = "USERNAME";
    public static final String RECIPIENT_TYPE_USER_ID = "USER_ID";
    public static final String RECIPIENT_TYPE_TOPIC = "TOPIC";
    public static Set<String> hiddenTemplateVars = Set.of("pass", "password", "secret", "otp", "token", "apikey", "auth", "credential", "cvv", "security", "code", "pin", "private", "certificate");
    @Schema(example="about swagger")
    private String subject;
    @Schema(example="<b>swagger notification</b>")
    @XmlElement(required=true)
    private String text;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"EMAIL", "SMS", "LOG"}, example="SMS")
    @XmlAttribute(required=true)
    private String channel = "EMAIL";
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, title="EMail Address or Phone Number")
    @XmlElementWrapper(name="recipients")
    @XmlElement(name="recipient")
    @JsonProperty(value="recipients")
    private List<String> recipients;
    @Schema(description="type of recipients string", allowableValues={"EMAIL", "PHONE", "USERNAME", "USER_ID"}, example="EMAIL")
    @XmlElement(required=true)
    private String recipientType;
    @Schema(example="from.swagger@sivona.vorwerk.de")
    private String sender;
    @Schema(example="email template")
    private String templateName;
    @Schema(example="lang variant")
    private String templateLang;
    private Map<String, Object> templateVars;
    private List<FileAttachment> attachments;

    public Notification() {
    }

    public Notification(String subject, String text) {
        this.subject = subject;
        this.text = text;
    }

    public void addRecipient(String recipient) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<String>();
        }
        this.recipients.add(recipient);
    }

    public void addAttachment(FileAttachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<FileAttachment>();
        }
        this.attachments.add(attachment);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public String getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(String recipientType) {
        this.recipientType = recipientType;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateLang() {
        return this.templateLang;
    }

    public void setTemplateLang(String templateLang) {
        this.templateLang = templateLang;
    }

    public Map<String, Object> getTemplateVars() {
        return this.templateVars;
    }

    public void setTemplateVars(Map<String, Object> templateVars) {
        this.templateVars = templateVars;
    }

    public List<FileAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<FileAttachment> attachments) {
        this.attachments = attachments;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.subject != null) {
            sb.append(", subject='").append(this.subject).append('\'');
        }
        if (this.text != null) {
            sb.append(", text='").append(this.text).append('\'');
        }
        if (this.channel != null) {
            sb.append(", channel='").append(this.channel).append('\'');
        }
        if (this.recipients != null) {
            sb.append(", recipients='").append(this.recipients).append('\'');
        }
        if (this.recipients != null) {
            sb.append(", recipientType='").append(this.recipientType).append('\'');
        }
        if (this.sender != null) {
            sb.append(", sender='").append(this.sender).append('\'');
        }
        if (this.templateName != null) {
            sb.append(", templateName='").append(this.templateName).append('\'');
        }
        if (this.templateName != null) {
            sb.append(", templateLang='").append(this.templateLang).append('\'');
        }
        if (this.templateVars != null) {
            sb.append(", templateVars='").append(this.hideSensitive(this.templateVars)).append('\'');
        }
        if (this.attachments != null) {
            sb.append(", attachments='").append(this.attachments).append('\'');
        }
        return sb;
    }

    private Map<String, Object> hideSensitive(Map<String, Object> templateVars) {
        return templateVars.entrySet().stream().map(e -> {
            if (this.isHidden((String)e.getKey())) {
                return Map.entry((String)e.getKey(), "***");
            }
            return e;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isHidden(String varKey) {
        if (varKey == null) {
            return false;
        }
        String propName = varKey.toLowerCase();
        return hiddenTemplateVars.stream().anyMatch(propName::contains);
    }
}

