/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.core.domain.range;

import com.fasterxml.jackson.annotation.JsonIgnore;
import inc.yukawa.chain.base.core.domain.range.BigDecimalRange;
import inc.yukawa.chain.base.core.domain.range.DateRange;
import inc.yukawa.chain.base.core.domain.range.InstantRange;
import inc.yukawa.chain.base.core.domain.range.IntRange;
import inc.yukawa.chain.base.core.domain.range.LocalDateRange;
import inc.yukawa.chain.base.core.domain.range.LocalDateTimeRange;
import inc.yukawa.chain.base.core.domain.range.Range;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Objects;

@Schema(subTypes={LocalDateRange.class, LocalDateTimeRange.class, DateRange.class, InstantRange.class, BigDecimalRange.class, LocalDateTimeRange.class, IntRange.class})
public class DataRange<V>
implements Range<V>,
Serializable {
    private static final long serialVersionUID = -2264502484393270341L;
    private V from;
    private V to;

    public DataRange() {
    }

    public DataRange(V valueFrom) {
        this.from = valueFrom;
    }

    public DataRange(V valueFrom, V valueTo) {
        this.from = valueFrom;
        this.to = valueTo;
    }

    @Override
    @XmlTransient
    public V getFrom() {
        return this.from;
    }

    public void setFrom(V valueFrom) {
        this.from = valueFrom;
    }

    @Override
    @XmlTransient
    public V getTo() {
        return this.to;
    }

    public void setTo(V valueTo) {
        this.to = valueTo;
    }

    @JsonIgnore
    public boolean isSet() {
        return this.to != null || this.from != null;
    }

    public boolean isInRange(V check) {
        return !this.isBeforeStart(check) && !this.isAfterEnd(check);
    }

    public boolean isBeforeStart(V check) {
        throw new UnsupportedOperationException("DataRange.isBefore: not supported");
    }

    public boolean isAfterEnd(V check) {
        throw new UnsupportedOperationException("DataRange.isAfter: not supported");
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    protected StringBuilder toStringFields(StringBuilder buffer) {
        return buffer.append(", from=").append(this.from).append(", to=").append(this.to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRange dataRange = (DataRange)o;
        return Objects.equals(this.from, dataRange.from) && Objects.equals(this.to, dataRange.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

