/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.elastic.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public abstract class ElasticConfigBase {
    @Value(value="${spring.elasticsearch.rest.uris:http://localhost:9200}")
    private List<URL> searchUrls;

    @Bean
    protected RestClientBuilder restClientBuilder() {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (URL url : this.searchUrls) {
            hosts.add(new HttpHost(url.getHost(), url.getPort(), url.getProtocol()));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        return builder;
    }

    @Bean(destroyMethod="close")
    public RestHighLevelClient restHighLevelClient(@Autowired RestClientBuilder builder) {
        return new RestHighLevelClient(builder);
    }

    protected String formatIndexFile(String baseName) {
        return String.format("classpath:/META-INF/elastic/%s.json", baseName);
    }
}

