/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.elastic.dao;

import inc.yukawa.chain.base.core.filter.OrderDir;
import inc.yukawa.chain.base.core.filter.Pager;
import inc.yukawa.chain.base.core.filter.TableFilter;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractElasticSearchHigh {
    private static final Logger log = LoggerFactory.getLogger(AbstractElasticSearchHigh.class);
    protected final RestHighLevelClient client;
    protected RequestOptions requestOptions = RequestOptions.DEFAULT;
    protected static final int SEARCH_SIZE_MAX = 10000;

    public AbstractElasticSearchHigh(RestHighLevelClient client) {
        this.client = client;
    }

    protected void searchOrder(SearchSourceBuilder source, String orderBy, OrderDir orderDir) {
        if (orderBy != null) {
            source.sort(orderBy, orderDir != null ? SortOrder.valueOf((String)orderDir.name()) : SortOrder.ASC);
        }
    }

    protected void searchPager(SearchSourceBuilder source, Pager pager) {
        if (pager != null) {
            if (pager.getPageSize() != null && pager.getPageSize() != 0) {
                source.size(pager.getPageSize().intValue());
            }
            if (pager.getFirstResult() != null) {
                source.from(pager.getFirstResult().intValue());
            }
        }
    }

    protected void searchTableFilter(SearchSourceBuilder searchSource, TableFilter filter) {
        if (filter.getTimeout() != null) {
            searchSource.timeout(TimeValue.timeValueMillis((long)filter.getTimeout()));
        }
        this.searchOrder(searchSource, this.mapOrderBy(filter.getOrderBy()), filter.getOrderDir());
        this.searchPager(searchSource, filter.getPager());
    }

    @Deprecated
    protected BoolQueryBuilder searchKeywordBuilder(String value, String ... fields) {
        BoolQueryBuilder keyQuery = QueryBuilders.boolQuery();
        String keyword = value.toLowerCase();
        for (String field : fields) {
            keyQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)keyword));
        }
        return keyQuery;
    }

    protected String mapOrderBy(String field) {
        if ("id".equals(field)) {
            return "_id";
        }
        return field;
    }
}

