/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.elastic.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.base.core.filter.Pager;
import inc.yukawa.chain.base.elastic.dao.ElasticReadDao;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public abstract class OrganizedElasticReadDao<K, V extends Organized, F extends EntityFilter>
extends ElasticReadDao<K, V, F> {
    protected String[] searchFields;

    public OrganizedElasticReadDao(String index, RestHighLevelClient restClient, ObjectMapper mapper, String[] searchFields, Class<V> clazz) {
        super(index, restClient, mapper, clazz);
        this.searchFields = searchFields;
    }

    protected BoolQueryBuilder findQueryBuilder(F filter) {
        BoolQueryBuilder builder = (BoolQueryBuilder)super.findQueryBuilder(filter);
        this.keywordQueryOn(builder, () -> filter.getKeyword(), this.searchFields);
        this.termsQueryOn(builder, () -> filter.getOrgId(), "orgId.keyword");
        return builder;
    }

    @Override
    protected void searchPager(SearchSourceBuilder source, Pager pager) {
        if (pager == null || pager.getPageSize() == null) {
            source.size(10000);
        }
        super.searchPager(source, pager);
    }

    @Override
    protected String mapOrderBy(String field) {
        if ("key".equals(field) || "_id".equals(field)) {
            return "_id";
        }
        if (OrganizedElasticReadDao.isString(this.valueClass, field)) {
            return field + ".keyword";
        }
        return super.mapOrderBy(field);
    }
}

