/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.elastic.dao;

import inc.yukawa.chain.base.mono.repos.SearchIndexAdmin;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class ElasticIndexAdmin
implements SearchIndexAdmin {
    private static final Logger log = LoggerFactory.getLogger(ElasticIndexAdmin.class);
    protected final String index;
    protected final RestHighLevelClient client;
    protected RequestOptions requestOptions = RequestOptions.DEFAULT;

    public ElasticIndexAdmin(String index, RestHighLevelClient client) {
        this.index = index;
        this.client = client;
    }

    public Mono<String> getIndexName() {
        return Mono.just((Object)this.index);
    }

    public void buildIndex(final String searchIndex, boolean delete, final Consumer<String> onSuccess, final Consumer<Throwable> onError) {
        if (delete) {
            this.deleteIndex(new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    log.debug("deleteIndex: {} isAcknowledged {}", (Object)searchIndex, (Object)response.isAcknowledged());
                    ElasticIndexAdmin.this.createIndex(searchIndex, onSuccess, onError);
                }

                public void onFailure(Exception e) {
                    log.error("deleteIndex: {} failed: {}", (Object)searchIndex, (Object)e.getMessage());
                    ElasticIndexAdmin.this.createIndex(searchIndex, onSuccess, onError);
                }
            }, searchIndex);
        } else {
            this.createMappings(searchIndex, onSuccess, onError);
        }
    }

    protected void deleteIndex(ActionListener<AcknowledgedResponse> listener, String ... index) {
        log.debug("deleteIndex: {}", Arrays.asList(index));
        DeleteIndexRequest req = new DeleteIndexRequest(index);
        this.client.indices().deleteAsync(req, this.requestOptions, listener);
    }

    protected void createIndex(String indexName, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        this.client.indices().createAsync(request, this.requestOptions, listener);
    }

    protected void createIndex(final String indexName, final Consumer<String> onSuccess, final Consumer<Throwable> onError) {
        this.createIndex(indexName, new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse response) {
                log.debug("createIndex: {} isAcknowledged {}", (Object)indexName, (Object)response.isAcknowledged());
                ElasticIndexAdmin.this.createMappings(indexName, onSuccess, onError);
            }

            public void onFailure(Exception e) {
                log.warn(e.getClass().getSimpleName() + " : " + e);
                onError.accept(e);
            }
        });
    }

    public Mono<Map<String, ?>> loadMapping() {
        return Mono.create(sink -> this.loadMapping(arg_0 -> ((MonoSink)sink).success(arg_0), arg_0 -> ((MonoSink)sink).error(arg_0)));
    }

    public void loadMapping(Consumer<Map<String, ?>> onSuccess, Consumer<Throwable> onError) {
        this.loadMapping(this.index, onSuccess, onError);
    }

    public void loadMapping(String indexName, final Consumer<Map<String, ?>> onSuccess, final Consumer<Throwable> onError) {
        this.loadMapping(indexName, new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                Map metaDataMap = getMappingsResponse.mappings();
                onSuccess.accept(metaDataMap);
            }

            public void onFailure(Exception e) {
                onError.accept(e);
            }
        });
    }

    public void loadMapping(String searchIndex, final ActionListener<GetMappingsResponse> listener) {
        GetMappingsRequest getRequest = new GetMappingsRequest();
        getRequest.indices(new String[]{searchIndex});
        this.client.indices().getMappingAsync(getRequest, this.requestOptions, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                listener.onResponse((Object)getMappingsResponse);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    protected void createMappings(final String indexName, final Consumer<String> onSuccess, final Consumer<Throwable> onError) {
        log.debug("createMappings {}", (Object)indexName);
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName});
        Resource mappingFile = this.getMappingFile();
        try {
            String result;
            if (mappingFile != null) {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.rawValue(mappingFile.getInputStream(), XContentType.JSON);
                request.source(builder);
                result = mappingFile.toString();
            } else {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                this.mappingProperties(builder);
                builder.endObject();
                request.source(builder);
                result = builder.generator().toString();
            }
            this.client.indices().putMappingAsync(request, this.requestOptions, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    log.debug("createMappings: {} isAcknowledged {}", (Object)indexName, (Object)response.isAcknowledged());
                    onSuccess.accept(result);
                }

                public void onFailure(Exception e) {
                    log.error("createMappings: " + e.getClass().getSimpleName() + " : " + e, (Throwable)e);
                    onError.accept(e);
                }
            });
        }
        catch (IOException e) {
            log.error(e.getClass().getSimpleName() + " creating mappings : " + e, (Throwable)e);
            onError.accept(e);
        }
    }

    protected Resource getMappingFile() {
        return null;
    }

    protected void mappingProperties(XContentBuilder builder) throws IOException {
        log.warn("mappingProperties: not implemented");
    }
}

