/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.elastic.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import inc.yukawa.chain.base.core.domain.range.DataRange;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import inc.yukawa.chain.base.core.filter.TableFilter;
import inc.yukawa.chain.base.elastic.dao.AbstractElasticSearchHigh;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticReadDao<K, V, F>
extends AbstractElasticSearchHigh
implements MonoReadDao<K, V, F> {
    private static final Logger log = LoggerFactory.getLogger(ElasticReadDao.class);
    protected final ObjectReader reader;
    protected final String index;
    protected long defaultTimeout = 5000L;
    protected final Class<V> valueClass;
    private final TypeReference<V> type = new TypeReference<V>(){};

    public ElasticReadDao(String index, RestHighLevelClient restClient, ObjectMapper mapper, Class<V> clazz) {
        super(restClient);
        this.valueClass = clazz;
        this.index = index;
        this.reader = mapper.readerFor(clazz);
    }

    public Flux<V> find(F filter) {
        log.debug("find by filter: {} from index: {}", filter, (Object)this.index);
        SearchRequest searchRequest = this.searchRequestFor(this.findQueryBuilder(filter), filter);
        return Mono.fromFuture(this.queryAsync("find", this.type.getType().getTypeName(), searchRequest)).flatMapIterable(QueryResult::getItems);
    }

    public Mono<QueryResult<V>> query(F filter) {
        return this.query(filter, "query", this.index);
    }

    protected Mono<QueryResult<V>> query(F filter, String op, String fqn) {
        log.debug("query by filter: {} from index: {}", filter, (Object)this.index);
        SearchRequest searchRequest = this.searchRequestFor(this.findQueryBuilder(filter), filter);
        return Mono.fromFuture(this.queryAsync(op, fqn, searchRequest));
    }

    public Mono<V> load(K key) {
        log.debug("load by key: {} from index: {}", key, (Object)this.index);
        SearchRequest searchRequest = this.searchRequestFor((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{String.valueOf(key)}), null);
        return Mono.fromFuture(this.queryAsync("load", this.type.getType().getTypeName(), searchRequest)).flatMapIterable(QueryResult::getItems).singleOrEmpty();
    }

    public Mono<V> read(F filter) {
        log.debug("read by filter: {} from index: {}", filter, (Object)this.index);
        SearchRequest searchRequest = this.searchRequestFor(this.findQueryBuilder(filter), filter);
        return Mono.fromFuture(this.queryAsync("read", this.index, searchRequest)).flatMapIterable(QueryResult::getItems).singleOrEmpty();
    }

    protected SearchRequest searchRequestFor(QueryBuilder query, F filter) {
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.timeout(TimeValue.timeValueMillis((long)this.defaultTimeout));
        if (filter instanceof TableFilter) {
            this.searchTableFilter(source, (TableFilter)filter);
        }
        source.query(query);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index}, source);
        log.debug("search request: {}", (Object)searchRequest.toString());
        return searchRequest;
    }

    protected CompletableFuture<QueryResult<V>> queryAsync(String op, String fqn, SearchRequest searchRequest) {
        CompletableFuture<QueryResult<V>> resFuture = new CompletableFuture<QueryResult<V>>();
        this.client.searchAsync(searchRequest, this.requestOptions, this.mappedQueryHitsListener(op, fqn, this.reader, resFuture));
        return resFuture;
    }

    protected <T> ActionListener<SearchResponse> mappedQueryHitsListener(final String op, final String fqn, final ObjectReader reader, final CompletableFuture<QueryResult<T>> resultFuture) {
        return new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse r) {
                SearchHit[] hitList;
                log.debug("mappedQueryHitsListener: {} {}", (Object)r.status(), (Object)r.getTook());
                QueryResult result = new QueryResult(op, fqn);
                result.setTook(Long.valueOf(r.getTook().getMillis()));
                result.addMessage(ResultDetail.info((String)(r.status() + " " + r.getTook()), (String)("" + r.status()), (String)"duration"));
                SearchHits hits = r.getHits();
                result.setRows(Integer.valueOf((int)hits.totalHits));
                ArrayList<Object> items = new ArrayList<Object>();
                for (SearchHit hit : hitList = hits.getHits()) {
                    try {
                        items.add(reader.readValue(hit.getSourceAsString()));
                    }
                    catch (IOException e) {
                        log.error(e.getClass().getSimpleName() + " : " + e, (Throwable)e);
                        result.addMessage(ResultDetail.error((Throwable)e));
                    }
                }
                log.debug("mappedQueryHitsListener: Mapped {} of {} hits", (Object)items.size(), (Object)hits.getTotalHits());
                result.setHasMore(Boolean.valueOf((long)items.size() < hits.getTotalHits()));
                result.setItems(items);
                resultFuture.complete(result);
            }

            public void onFailure(Exception e) {
                log.warn("mappedQueryHitsListener: Elastic search error", (Throwable)e);
                QueryResult result = new QueryResult(op, fqn);
                result.addMessage(ResultDetail.error((Throwable)e));
                resultFuture.complete(result);
            }
        };
    }

    protected QueryBuilder findQueryBuilder(F filter) {
        return QueryBuilders.boolQuery();
    }

    @Override
    protected String mapOrderBy(String field) {
        return super.mapOrderBy(field);
    }

    public Mono<Long> count(F filter) {
        log.debug("count by filter: {} from index: {}", filter, (Object)this.index);
        SearchRequest searchRequest = this.searchRequestFor(this.findQueryBuilder(filter), filter);
        return Mono.fromFuture(this.queryAsync("count", this.index, searchRequest)).map(r -> (long)r.getRows());
    }

    public Mono<Map<K, V>> map(F filter) {
        throw new UnsupportedOperationException("ElasticReadDao.map not implemented");
    }

    protected void idQueryOn(BoolQueryBuilder builder, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            builder.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{filterValue}));
        }
    }

    protected void multiIdQueryOn(BoolQueryBuilder builder, Supplier<Collection<String>> getter) {
        Collection<String> filterValue = getter.get();
        if (filterValue != null) {
            builder.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(filterValue.toArray(new String[0])));
        }
    }

    protected void matchQueryOn(BoolQueryBuilder builder, Supplier<Object> getter, String field) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)filterValue));
        }
    }

    protected void multiMatchQueryOn(BoolQueryBuilder builder, Supplier<Object> getter, String ... fields) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            builder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)filterValue, (String[])fields));
        }
    }

    protected void termsQueryOn(BoolQueryBuilder builder, Supplier<Object> getter, String field) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            builder.must((QueryBuilder)QueryBuilders.termsQuery((String)field, (Object[])new Object[]{filterValue}));
        }
    }

    protected void multiTermsQueryOn(BoolQueryBuilder builder, Supplier<Collection<?>> getter, String field) {
        Collection<?> filterValue = getter.get();
        if (filterValue != null) {
            builder.must((QueryBuilder)QueryBuilders.termsQuery((String)field, filterValue));
        }
    }

    protected void multiTermsQueryOn(DisMaxQueryBuilder builder, Supplier<Collection<?>> getter, String field) {
        Collection<?> values = getter.get();
        if (values != null) {
            builder.add((QueryBuilder)QueryBuilders.termsQuery((String)field, values));
        }
    }

    protected void orTermsQueryOn(BoolQueryBuilder builder, Supplier<Object> getter, String ... fields) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            DisMaxQueryBuilder orQuery = QueryBuilders.disMaxQuery();
            for (String field : fields) {
                orQuery = orQuery.add((QueryBuilder)QueryBuilders.termsQuery((String)field, (Object[])new Object[]{filterValue}));
            }
            builder.must((QueryBuilder)orQuery);
        }
    }

    protected void orMultiTermsOrQueryOn(BoolQueryBuilder builder, Supplier<Collection<?>> getter, String ... fields) {
        Collection<?> filterValue = getter.get();
        if (filterValue != null) {
            DisMaxQueryBuilder orQuery = QueryBuilders.disMaxQuery();
            for (String field : fields) {
                orQuery = orQuery.add((QueryBuilder)QueryBuilders.termsQuery((String)field, filterValue));
            }
            builder.must((QueryBuilder)orQuery);
        }
    }

    protected void rangeQueryOn(BoolQueryBuilder builder, Supplier<DataRange<?>> getter, String field) {
        DataRange<?> range = getter.get();
        if (range != null) {
            if (range.getFrom() != null) {
                builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).gte((Object)range.getFrom().toString()));
            }
            if (range.getTo() != null) {
                builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).lte((Object)range.getTo().toString()));
            }
        }
    }

    protected void keywordQueryOn(BoolQueryBuilder builder, Supplier<String> getter, String ... fields) {
        String filterValue = getter.get();
        if (filterValue != null) {
            String keyword = getter.get().toLowerCase();
            BoolQueryBuilder q = QueryBuilders.boolQuery();
            for (String field : fields) {
                q.should((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)keyword));
            }
            builder.must((QueryBuilder)q);
        }
    }

    public static boolean isString(Class<?> clazz, String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            return false;
        }
        if (propertyName.contains(".")) {
            int dotIndex = propertyName.indexOf(".");
            Class sub = BeanUtils.findPropertyType((String)propertyName.substring(0, dotIndex), (Class[])new Class[]{clazz});
            return ElasticReadDao.isString(sub, propertyName.substring(dotIndex + 1));
        }
        return String.class.isAssignableFrom(BeanUtils.findPropertyType((String)propertyName, (Class[])new Class[]{clazz}));
    }
}

