/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.generator.rest2ts.swagger;

import com.blueveery.springrest2ts.Rest2tsGenerator;
import com.blueveery.springrest2ts.converters.ComplexTypeConverter;
import com.blueveery.springrest2ts.converters.ConfigurableTsModulesConverter;
import com.blueveery.springrest2ts.converters.ConversionListener;
import com.blueveery.springrest2ts.converters.JacksonObjectMapper;
import com.blueveery.springrest2ts.converters.JavaEnumToTsEnumConverter;
import com.blueveery.springrest2ts.converters.JavaPackageToTsModuleConverter;
import com.blueveery.springrest2ts.converters.ModelClassesAbstractConverter;
import com.blueveery.springrest2ts.converters.ModelClassesToTsInterfacesConverter;
import com.blueveery.springrest2ts.converters.NullableTypesStrategy;
import com.blueveery.springrest2ts.converters.ObjectMapper;
import com.blueveery.springrest2ts.converters.RestClassConverter;
import com.blueveery.springrest2ts.converters.SpringRestToTsConverter;
import com.blueveery.springrest2ts.converters.TypeMapper;
import com.blueveery.springrest2ts.filters.JavaTypeFilter;
import com.blueveery.springrest2ts.implgens.Angular4ImplementationGenerator;
import com.blueveery.springrest2ts.implgens.ImplementationGenerator;
import com.blueveery.springrest2ts.tsmodel.TSModule;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import inc.yukawa.chain.base.generator.rest2ts.ChainRest2TsGenerator;
import inc.yukawa.chain.base.generator.rest2ts.model.EnumConverter;
import inc.yukawa.chain.base.generator.rest2ts.swagger.AbstractRest2TsLibConfig;
import inc.yukawa.chain.base.generator.rest2ts.swagger.SwaggerClientConversionListener;
import inc.yukawa.chain.base.generator.rest2ts.swagger.SwaggerModelConversionListener;
import inc.yukawa.chain.base.generator.rest2ts.swagger.SwaggerNullableTypesStrategy;
import io.swagger.annotations.ApiModel;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RestController;

public abstract class AbstractRest2TsGenConfig
extends AbstractRest2TsLibConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractRest2TsGenConfig.class);
    @Value(value="${gen.target.dir}")
    protected File outputDir;
    @Value(value="${gen.pkg.base-domain:chain-base-angular-domain}")
    protected String baseDomainName;
    @Qualifier(value="modelConversionListener")
    @Autowired(required=false)
    protected ConversionListener modelConversionListener;
    @Qualifier(value="clientConversionListener")
    @Autowired(required=false)
    protected ConversionListener clientConversionListener;

    @Bean(value={"generator"})
    public ChainRest2TsGenerator rest2TsGenerator(@Qualifier(value="scanPackages") Set<String> scanPackages, @Qualifier(value="modelClassesCondition") JavaTypeFilter modelClassesCondition, @Qualifier(value="restClassesCondition") JavaTypeFilter restClassesCondition, ModelClassesAbstractConverter modelClassesConverter, RestClassConverter restToTsConverter, JavaPackageToTsModuleConverter javaPackageToTsModuleConverter) {
        ChainRest2TsGenerator tsGenerator = new ChainRest2TsGenerator(scanPackages, this.outputDir);
        this.customTypes(tsGenerator);
        tsGenerator.setEnumConverter((ComplexTypeConverter)this.enumConverter());
        tsGenerator.setNullableTypesStrategy((NullableTypesStrategy)new SwaggerNullableTypesStrategy());
        tsGenerator.setModelClassesCondition(modelClassesCondition);
        tsGenerator.setModelClassesConverter(modelClassesConverter);
        tsGenerator.setRestClassesCondition(restClassesCondition);
        tsGenerator.setRestClassesConverter(restToTsConverter);
        tsGenerator.setJavaPackageToTsModuleConverter(javaPackageToTsModuleConverter);
        return tsGenerator;
    }

    @Bean
    public Set<String> scanPackages(@Qualifier(value="packageMap") Map<String, TSModule> packageMap) {
        return new HashSet<String>(packageMap.keySet());
    }

    @Bean
    protected JavaTypeFilter restClassesCondition() {
        return this.annoFilter(RestController.class);
    }

    @Bean
    protected JavaTypeFilter modelClassesCondition() {
        return this.orFilter(new JavaTypeFilter[]{this.annoFilter(XmlType.class), this.annoFilter(XmlRootElement.class), this.annoFilter(ApiModel.class)});
    }

    protected void customTypes(Rest2tsGenerator tsGenerator) {
        tsGenerator.getCustomTypeMapping().put(Instant.class, TypeMapper.tsString);
        tsGenerator.getCustomTypeMapping().put(UUID.class, TypeMapper.tsString);
        tsGenerator.getCustomTypeMapping().put(BigInteger.class, TypeMapper.tsNumber);
        tsGenerator.getCustomTypeMapping().put(BigDecimal.class, TypeMapper.tsNumber);
        tsGenerator.getCustomTypeMapping().put(LocalTime.class, TypeMapper.tsString);
        tsGenerator.getCustomTypeMapping().put(LocalDateTime.class, TypeMapper.tsString);
        tsGenerator.getCustomTypeMapping().put(LocalDate.class, TypeMapper.tsDate);
    }

    @Bean
    protected ImplementationGenerator implementationGenerator() {
        return new Angular4ImplementationGenerator();
    }

    @Bean
    protected RestClassConverter restClassesConverter(ImplementationGenerator implementationGenerator) {
        SpringRestToTsConverter restToTsConverter = new SpringRestToTsConverter(implementationGenerator){};
        if (this.clientConversionListener != null) {
            restToTsConverter.getConversionListener().getConversionListenerSet().add(this.clientConversionListener);
        }
        return restToTsConverter;
    }

    @Bean
    protected ModelClassesAbstractConverter modelClassesConverter() {
        JacksonObjectMapper jacksonObjectMapper = this.jacksonObjectMapper();
        ModelClassesToTsInterfacesConverter modelClassesConverter = new ModelClassesToTsInterfacesConverter((ObjectMapper)jacksonObjectMapper);
        if (this.modelConversionListener != null) {
            modelClassesConverter.getConversionListener().getConversionListenerSet().add(this.modelConversionListener);
        }
        return modelClassesConverter;
    }

    @Bean
    protected ConversionListener modelConversionListener() {
        return new SwaggerModelConversionListener();
    }

    @Bean
    protected ConversionListener clientConversionListener() {
        return new SwaggerClientConversionListener();
    }

    protected JavaEnumToTsEnumConverter enumConverter() {
        return new EnumConverter();
    }

    protected JacksonObjectMapper jacksonObjectMapper() {
        JacksonObjectMapper jacksonObjectMapper = new JacksonObjectMapper();
        jacksonObjectMapper.setFieldsVisibility(JsonAutoDetect.Visibility.ANY);
        return jacksonObjectMapper;
    }

    @Bean
    protected JavaPackageToTsModuleConverter javaPackageToTsModuleConverter(@Qualifier(value="packageMap") Map<String, TSModule> packageMap) {
        return new ConfigurableTsModulesConverter(packageMap);
    }

    protected TSModule baseCoreModule(Path path, boolean external, HashMap<String, TSModule> packagesMap) {
        TSModule module = this.tsModule(this.baseDomainName, path, external, packagesMap, "inc.yukawa.chain.base.core.aspect", "inc.yukawa.chain.base.core.domain.access", "inc.yukawa.chain.base.core.domain.change", "inc.yukawa.chain.base.core.domain.custom", "inc.yukawa.chain.base.core.domain.entity", "inc.yukawa.chain.base.core.domain.file", "inc.yukawa.chain.base.core.domain.info", "inc.yukawa.chain.base.core.domain.module", "inc.yukawa.chain.base.core.domain.organization", "inc.yukawa.chain.base.core.domain.person", "inc.yukawa.chain.base.core.domain.range", "inc.yukawa.chain.base.core.domain.result", "inc.yukawa.chain.base.core.domain.label", "inc.yukawa.chain.base.core.event", "inc.yukawa.chain.base.core.filter", "inc.yukawa.chain.base.core.util");
        log.info("baseCoreModule: {}/{} {}", new Object[]{module.getModuleRelativePath(), module.getName(), module.isExternal()});
        return module;
    }
}

