/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.generator.rest2ts.swagger;

import com.blueveery.springrest2ts.converters.TypeMapper;
import com.blueveery.springrest2ts.tsmodel.ICommentedElement;
import com.blueveery.springrest2ts.tsmodel.TSArray;
import com.blueveery.springrest2ts.tsmodel.TSCommentSection;
import com.blueveery.springrest2ts.tsmodel.TSMethod;
import com.blueveery.springrest2ts.tsmodel.TSParameter;
import com.blueveery.springrest2ts.tsmodel.TSScopedElement;
import com.blueveery.springrest2ts.tsmodel.TSType;
import inc.yukawa.chain.base.generator.rest2ts.swagger.SwaggerConversionListener;
import io.swagger.v3.oas.annotations.Operation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SwaggerClientConversionListener
extends SwaggerConversionListener {
    private static final Logger log = LoggerFactory.getLogger(SwaggerClientConversionListener.class);
    @Value(value="${gen.rest.jsdoc:full}")
    protected String jsDoc;

    public void tsScopedTypeCreated(Class javaType, TSScopedElement tsScopedElement) {
        if (this.genJsDoc(this.jsDoc, javaType)) {
            tsScopedElement.getTsComment().getTsCommentSection("@generator").getCommentText().append("@generator rest2ts");
            tsScopedElement.getTsComment().getTsCommentSection("javaType").getCommentText().append("javaType: ").append(javaType.getName()).append(" <br/>");
        }
    }

    public void tsParameterCreated(Parameter parameter, TSParameter tsParameter) {
        tsParameter.setName(this.findParaName(parameter));
    }

    public void tsMethodCreated(Method method, TSMethod tsMethod) {
        Type returnType;
        Operation apiOp = method.getAnnotation(Operation.class);
        this.applyOperationAnnotation((ICommentedElement)tsMethod, apiOp);
        TSType tsType = null;
        if (tsType == null && (returnType = method.getGenericReturnType()) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (parameterizedType.getRawType() == Mono.class) {
                tsType = this.mapType(parameterizedType.getActualTypeArguments()[0], TypeMapper.tsAny);
                tsType = this.applyType(tsMethod, tsType);
            } else if (parameterizedType.getRawType() == Flux.class) {
                tsType = new TSArray(this.mapType(parameterizedType.getActualTypeArguments()[0], TypeMapper.tsAny));
                tsType = this.applyType(tsMethod, tsType);
            }
        }
    }

    protected TSType applyType(TSMethod tsMethod, Class<?> cls) {
        TSType tsType = this.mapType(cls);
        return this.applyType(tsMethod, tsType);
    }

    protected TSType applyType(TSMethod tsMethod, TSType tsType) {
        tsMethod.setType(tsType);
        tsMethod.getOwner().addScopedTypeUsage(tsType);
        return tsType;
    }

    private void applyOperationAnnotation(ICommentedElement commentedElement, Operation operationAnnotation) {
        if (this.genJsDoc(this.jsDoc, commentedElement) && operationAnnotation != null && !"".equals(operationAnnotation.description())) {
            TSCommentSection tsCommentSection = commentedElement.getTsComment().getTsCommentSection("swagger");
            tsCommentSection.getCommentText().append(operationAnnotation.description());
            tsCommentSection.getCommentText().append("\n");
        }
    }
}

