/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.generator.rest2ts.swagger;

import com.blueveery.springrest2ts.converters.Property;
import com.blueveery.springrest2ts.tsmodel.TSField;
import com.blueveery.springrest2ts.tsmodel.TSScopedElement;
import inc.yukawa.chain.base.generator.rest2ts.swagger.SwaggerConversionListener;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SwaggerModelConversionListener
extends SwaggerConversionListener {
    private static final Logger log = LoggerFactory.getLogger(SwaggerModelConversionListener.class);
    @Value(value="${gen.model.jsdoc:full}")
    protected String jsDoc;
    @Value(value="${gen.model.fields.optional:all}")
    protected String fieldsOptional;

    public void tsScopedTypeCreated(Class javaType, TSScopedElement tsScopedElement) {
        Schema apiModel = javaType.getAnnotation(Schema.class);
        if (apiModel != null && !"".equals(apiModel.name())) {
            tsScopedElement.setName(apiModel.name());
        }
        if (this.isExternal(tsScopedElement)) {
            return;
        }
        log.debug("tsScopedTypeCreated: {} => {} {}", new Object[]{javaType.getSimpleName(), tsScopedElement.getName(), tsScopedElement});
        if (this.genJsDoc(this.jsDoc, javaType)) {
            tsScopedElement.getTsComment().getTsCommentSection("@generator").getCommentText().append("@generator rest2ts");
            tsScopedElement.getTsComment().getTsCommentSection("javaType").getCommentText().append("javaType: ").append(javaType.getName()).append(" <br/>");
            if (javaType.getDeclaredAnnotation(Deprecated.class) != null) {
                tsScopedElement.getTsComment().getTsCommentSection("@deprecated").getCommentText().append("@deprecated");
            }
            if (apiModel != null && !"".equals(apiModel.description())) {
                tsScopedElement.getTsComment().getTsCommentSection("description").getCommentText().append(apiModel.description()).append(" <br/>");
            }
        }
    }

    public void tsFieldCreated(Property property, TSField tsField) {
        Schema apiProp = (Schema)property.getDeclaredAnnotation(Schema.class);
        log.debug("tsFieldCreated: {}.{} {}", new Object[]{property.getDeclaringClass().getSimpleName(), property.getName(), apiProp});
        if ("all".equalsIgnoreCase(this.fieldsOptional)) {
            tsField.setOptional(true);
        } else if (!this.isFieldRequired(property, tsField)) {
            tsField.setOptional(true);
        }
        if (this.isExternal((TSScopedElement)tsField.getOwner())) {
            return;
        }
        if (this.genJsDoc(this.jsDoc, property)) {
            if (this.findAnnotation(property, Deprecated.class) != null) {
                tsField.getTsComment().getTsCommentSection("@deprecated").getCommentText().append("@deprecated");
            }
            if (apiProp != null) {
                if (!"".equals(apiProp.name())) {
                    tsField.getTsComment().getTsCommentSection("name").getCommentText().append("name: ").append(apiProp.name()).append("<br/>");
                }
                if (!"".equals(apiProp.example())) {
                    tsField.getTsComment().getTsCommentSection("@example").getCommentText().append("@example ").append(apiProp.example());
                }
                if (apiProp.allowableValues() != null && apiProp.allowableValues().length > 0) {
                    tsField.getTsComment().getTsCommentSection("allowableValues").getCommentText().append("values: ").append(Arrays.toString(apiProp.allowableValues())).append("<br/>");
                }
            }
        }
    }

    protected <A extends Annotation> A findAnnotation(Property property, Class<A> ac) {
        Annotation annotation = property.getDeclaredAnnotation(ac);
        if (annotation != null) {
            return (A)annotation;
        }
        if (property.getGetter() != null && (annotation = property.getGetter().getDeclaredAnnotation(ac)) != null) {
            return (A)annotation;
        }
        if (property.getSetter() != null) {
            annotation = property.getSetter().getDeclaredAnnotation(ac);
            return (A)annotation;
        }
        return null;
    }
}

