/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

public abstract class FullTextSearchHibernateReactiveReadDao<K, E extends Keyed<K>, F extends EntityFilter>
extends HibernateReactiveReadDao<K, E, F> {
    private static final Logger LOG = LoggerFactory.getLogger(FullTextSearchHibernateReactiveReadDao.class);
    public static final String MATCH_RANK_PREFIX = "match_rank@";
    protected String ftsConfiguration = "english";
    protected Integer rankNormalization = 0;

    public FullTextSearchHibernateReactiveReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
        this.keyClass = ResolvableType.forInstance((Object)this).as(FullTextSearchHibernateReactiveReadDao.class).getGeneric(new int[]{0}).toClass();
        this.entityClass = ResolvableType.forInstance((Object)this).as(FullTextSearchHibernateReactiveReadDao.class).getGeneric(new int[]{1}).getRawClass();
    }

    public FullTextSearchHibernateReactiveReadDao(Mutiny.SessionFactory sessionFactory, String loadGraphName) {
        this(sessionFactory);
        this.loadGraphName = loadGraphName;
    }

    public void setFtsConfiguration(String ftsConfiguration) {
        this.ftsConfiguration = ftsConfiguration;
    }

    public void setRankNormalization(Integer rankNormalization) {
        this.rankNormalization = rankNormalization;
    }

    protected <T> void whereFullTextSearch(List<Predicate> predicates, CriteriaBuilder cb, String tsVectorField, Root<T> root, Supplier<String> searchTextGetter, String ftsConfiguration) {
        this.whereFullTextSearch(predicates, cb, this.resolveField(tsVectorField, root), searchTextGetter, ftsConfiguration);
    }

    protected <T> void whereFullTextSearch(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> tsVectorField, Supplier<String> searchTextGetter, String ftsConfiguration) {
        this.whereFullTextSearch(predicates, cb, Collections.singletonList(tsVectorField), searchTextGetter, ftsConfiguration);
    }

    protected <T> void whereFullTextSearch(List<Predicate> predicates, CriteriaBuilder cb, String[] tsVectorFields, Root<T> root, Supplier<String> searchTextGetter, String ftsConfiguration) {
        this.whereFullTextSearch(predicates, cb, this.resolveFields(tsVectorFields, root), searchTextGetter, ftsConfiguration);
    }

    protected void whereFullTextSearch(List<Predicate> predicates, CriteriaBuilder cb, List<Expression<?>> tsVectorFields, Supplier<String> searchTextGetter, String ftsConfiguration) {
        String searchText = searchTextGetter.get();
        if (searchText != null) {
            String searchExpression = this.searchExpression(searchText);
            ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
            for (Expression<?> tsVectorField : tsVectorFields) {
                restrictions.add(cb.isTrue(this.fullTextSearch(cb, tsVectorField, ftsConfiguration, searchExpression)));
            }
            predicates.add(cb.or(restrictions.toArray(new Predicate[0])));
        }
    }

    protected Expression<Boolean> fullTextSearch(CriteriaBuilder cb, Expression<?> tsVectorField, String ftsConfiguration, String searchExpression) {
        return cb.function("fts", Boolean.class, new Expression[]{tsVectorField, this.websearchToTsQuery(cb, ftsConfiguration, searchExpression)});
    }

    protected Expression<Object> websearchToTsQuery(CriteriaBuilder cb, String ftsConfiguration, String exp) {
        if (ftsConfiguration == null) {
            return cb.function("websearch_to_tsquery", Object.class, new Expression[]{cb.literal((Object)exp)});
        }
        return cb.function("websearch_to_tsquery", Object.class, new Expression[]{cb.literal((Object)ftsConfiguration), cb.literal((Object)exp)});
    }

    protected String searchExpression(String searchText) {
        return searchText;
    }

    @Override
    protected <T> Expression<?> orderByExpression(String p, Root<T> root, CriteriaBuilder cb, CriteriaQuery<?> query, F filter, boolean withoutLeftJoins) {
        if (p.startsWith(MATCH_RANK_PREFIX)) {
            String prop = p.substring(MATCH_RANK_PREFIX.length());
            return cb.function("ts_rank_cd", Double.class, new Expression[]{withoutLeftJoins ? this.resolveFieldWithoutLeftJoin(prop, root) : this.resolveField(prop, root), this.websearchToTsQuery(cb, this.ftsConfiguration, this.searchExpression(filter.getKeyword())), cb.literal((Object)this.rankNormalization)});
        }
        return withoutLeftJoins ? this.resolveFieldWithoutLeftJoin(p, root) : this.resolveField(p, root);
    }
}

