/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.core.filter.OrderDir;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveDao;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HibernateReactiveReadDao<K, E extends Keyed<K>, F extends EntityFilter>
extends HibernateReactiveDao
implements MonoReadDao<K, E, F> {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateReactiveReadDao.class);
    protected Class<K> keyClass = ResolvableType.forInstance((Object)this).as(HibernateReactiveReadDao.class).getGeneric(new int[]{0}).toClass();
    protected Class<E> entityClass = ResolvableType.forInstance((Object)this).as(HibernateReactiveReadDao.class).getGeneric(new int[]{1}).getRawClass();
    protected String loadGraphName;
    protected Boolean nullLastOrdering;

    public HibernateReactiveReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public HibernateReactiveReadDao(Mutiny.SessionFactory sessionFactory, String loadGraphName) {
        this(sessionFactory);
        this.loadGraphName = loadGraphName;
    }

    public void setLoadGraphName(String loadGraphName) {
        this.loadGraphName = loadGraphName;
    }

    @Override
    public void setAppendOrderByPK(boolean appendOrderByPK) {
        this.appendOrderByPK = appendOrderByPK;
    }

    public void setNullLastOrdering(Boolean nullLastOrdering) {
        this.nullLastOrdering = nullLastOrdering;
    }

    public Mono<E> load(K key) {
        LOG.debug("[{}] load: {}@{}", new Object[]{this.getClass().getSimpleName(), key, this.entityClass.getSimpleName()});
        return (Mono)this.sessionFactory.withTransaction(session -> {
            EntityGraph<E> graph = this.graphForLoad((Mutiny.Session)session);
            Uni found = graph != null ? session.find(graph, key) : session.find(this.entityClass, key);
            return found.ifNoItem().after(Duration.ofMillis(this.queryTimeout)).failWith(() -> new QueryTimeoutException("load timeout reached")).chain(this::enrichLoaded).invoke(e -> LOG.debug("Loaded {}@{}", e != null ? e.key() : null, (Object)this.entityClass.getSimpleName()));
        }).convert().with((Function)UniReactorConverters.toMono());
    }

    public Flux<E> find(F filter) {
        return this.query(filter, true).flatMapIterable(QueryResult::getItems);
    }

    public Mono<QueryResult<E>> query(F filter) {
        return this.query(filter, false);
    }

    public Mono<QueryResult<E>> query(F filter, boolean skipCount) {
        LOG.debug("[{}] query: {}", (Object)this.getClass().getSimpleName(), filter);
        CriteriaBuilder cb = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.entityClass);
        Root<?> root = this.buildQuery(query, cb, filter);
        return (Mono)this.sessionFactory.withTransaction(session -> {
            Uni resultListUni;
            boolean shouldQueryThenFetch;
            boolean bl = shouldQueryThenFetch = this.hasCollectionFetch(root.getFetches()) && this.hasPagination(filter) && root.getModel().hasSingleIdAttribute() || query.isDistinct() && root.getModel().hasSingleIdAttribute() && filter.getOrderBy() != null;
            if (shouldQueryThenFetch) {
                Mutiny.SelectionQuery q = session.createQuery(this.getQueryForIds(cb, filter));
                this.withPagination(q, filter);
                resultListUni = q.getResultList().ifNoItem().after(Duration.ofMillis(this.timeout(filter))).failWith(() -> new QueryTimeoutException("query timeout reached")).invoke(l -> LOG.debug("Got {} {} keys", (Object)l.size(), (Object)this.entityClass.getSimpleName())).map(this::getFirstColumnAsKey).chain(ids -> {
                    if (ids.isEmpty()) {
                        return Uni.createFrom().item(new ArrayList());
                    }
                    CriteriaQuery<E> queryByIds = this.getQueryByIds(cb, filter, (List<K>)ids);
                    return session.createQuery(queryByIds).getResultList().map(result -> this.orderByGivenIds((List<E>)result, (List<K>)ids));
                });
            } else {
                Mutiny.SelectionQuery q = session.createQuery(query);
                this.withPagination(q, filter);
                resultListUni = q.getResultList();
            }
            return resultListUni.ifNoItem().after(Duration.ofMillis(this.timeout(filter))).failWith(() -> new QueryTimeoutException("query timeout reached")).invoke(l -> LOG.debug("Got {} {} results", (Object)l.size(), (Object)this.entityClass.getSimpleName())).chain(l -> this.enrichQueried((List<E>)l, filter)).map(QueryResult::new).flatMap(r -> {
                if (this.countingEnabled && !skipCount && this.hasPagination(filter)) {
                    boolean firstResultMiss;
                    boolean bl = firstResultMiss = filter.getPager().getFirstResult() != null && filter.getPager().getFirstResult() > 0 && r.getItems().isEmpty();
                    if (firstResultMiss || filter.getPager().getPageSize() != null && r.getItems().size() >= filter.getPager().getPageSize()) {
                        Mutiny.SelectionQuery q = session.createQuery(this.getQueryForCount(cb, filter));
                        return q.getSingleResult().invoke(c -> LOG.debug("Counted {} {} rows", c, (Object)this.entityClass.getSimpleName())).map(count -> {
                            int firstResult = filter.getPager().getFirstResult() != null ? filter.getPager().getFirstResult() : 0;
                            r.setRows(Integer.valueOf(count.intValue()));
                            r.setHasMore(Boolean.valueOf(firstResult + r.getItems().size() < r.getRows()));
                            return r;
                        });
                    }
                    int firstResult = filter.getPager().getFirstResult() != null ? filter.getPager().getFirstResult() : 0;
                    r.setRows(Integer.valueOf(firstResult + r.getItems().size()));
                    r.setHasMore(Boolean.valueOf(false));
                    return Uni.createFrom().item(r);
                }
                return Uni.createFrom().item(r);
            });
        }).convert().with((Function)UniReactorConverters.toMono());
    }

    public Mono<Long> count(F filter) {
        LOG.debug("[{}] count: {}", (Object)this.getClass().getSimpleName(), filter);
        CriteriaBuilder cb = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery<Long> query = this.getQueryForCount(cb, filter);
        return (Mono)this.sessionFactory.withTransaction(session -> {
            Mutiny.SelectionQuery q = session.createQuery(query);
            return q.getSingleResult().ifNoItem().after(Duration.ofMillis(this.timeout(filter))).failWith(() -> new QueryTimeoutException("query timeout reached")).invoke(count -> LOG.debug("Counted {} {} rows", count, (Object)this.entityClass.getSimpleName()));
        }).convert().with((Function)UniReactorConverters.toMono());
    }

    public Flux<K> findKeys(F filter) {
        LOG.debug("[{}] findKeys: {}", (Object)this.getClass().getSimpleName(), filter);
        CriteriaBuilder cb = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = this.getQueryForIds(cb, filter);
        return ((Mono)this.sessionFactory.withTransaction(session -> {
            Mutiny.SelectionQuery q = session.createQuery(query);
            this.withPagination(q, filter);
            return q.getResultList().ifNoItem().after(Duration.ofMillis(this.timeout(filter))).failWith(() -> new QueryTimeoutException("query timeout reached")).map(this::getFirstColumnAsKey).invoke(l -> LOG.debug("[{}] Got {} {} keys", new Object[]{this.getClass().getSimpleName(), l.size(), this.entityClass.getSimpleName()}));
        }).convert().with((Function)UniReactorConverters.toMono())).flatMapIterable(Function.identity());
    }

    protected void withPagination(Mutiny.SelectionQuery<?> q, F filter) {
        if (this.hasPagination(filter)) {
            q.setFirstResult(Optional.ofNullable(filter.getPager().getFirstResult()).orElse(0).intValue());
            q.setMaxResults(Optional.ofNullable(filter.getPager().getPageSize()).orElse(this.defaultMaxResults).intValue());
        }
    }

    private boolean hasCollectionFetch(Set<? extends Fetch<?, ?>> fetches) {
        return fetches.stream().anyMatch(f -> f.getAttribute().isCollection() || f.getParent() != null && this.hasCollectionFetch(f.getFetches()));
    }

    protected long timeout(F filter) {
        return filter.getTimeout() != null ? filter.getTimeout() : (long)this.queryTimeout;
    }

    protected boolean hasPagination(F filter) {
        return filter.getPager() != null && (filter.getPager().getPageSize() != null || filter.getPager().getFirstResult() != null);
    }

    public Mono<Map<K, E>> map(F filter) {
        return this.find(filter).collectList().map(l -> l.stream().collect(Collectors.toMap(Keyed::key, Function.identity())));
    }

    protected EntityGraph<E> graphForLoad(Mutiny.Session session) {
        return this.graphNameForLoad() != null ? session.getEntityGraph(this.entityClass, this.graphNameForLoad()) : null;
    }

    protected String graphNameForLoad() {
        return this.loadGraphName;
    }

    protected Uni<E> enrichLoaded(E entity) {
        return this.enrich(entity, null);
    }

    protected Uni<List<E>> enrichQueried(List<E> entities, F filter) {
        return Multi.createFrom().iterable(entities).call(e -> this.enrich(e, filter)).collect().asList();
    }

    protected Uni<E> enrich(E entity, F filter) {
        return Uni.createFrom().item(entity);
    }

    protected Root<?> buildQuery(CriteriaQuery<?> query, CriteriaBuilder cb, F filter) {
        Root root = query.from(this.entityClass);
        this.withFetch(query, root, filter);
        query.where(this.withPredicates(query, filter, root, cb).toArray(new Predicate[0]));
        this.withOrderBy(cb, filter, query, root);
        return root;
    }

    protected CriteriaQuery<Tuple> getQueryForIds(CriteriaBuilder cb, F filter) {
        CriteriaQuery query = cb.createTupleQuery();
        Root root = query.from(this.entityClass);
        ArrayList<Object> selectFields = new ArrayList<Object>();
        if (root.getModel().hasSingleIdAttribute()) {
            selectFields.add(root.get(root.getModel().getId(this.keyClass)));
        } else {
            root.getModel().getIdClassAttributes().forEach(a -> selectFields.add(root.get(a)));
        }
        List<Expression<?>> orderByFields = this.getOrderByFields(cb, filter, query, root, false);
        selectFields.addAll(orderByFields);
        query.multiselect(selectFields);
        query.distinct(true);
        query.where(this.withPredicates(query, filter, root, cb).toArray(new Predicate[0]));
        this.withOrderBy(cb, filter, query, orderByFields);
        return query;
    }

    protected CriteriaQuery<Long> getQueryForCount(CriteriaBuilder cb, F filter) {
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(this.entityClass);
        if (root.getModel().hasSingleIdAttribute()) {
            query.select((Selection)cb.countDistinct((Expression)root.get(root.getModel().getId(this.keyClass))));
        } else {
            ArrayList selectFields = new ArrayList();
            Expression concatenatedPK = root.getModel().getIdClassAttributes().stream().map(arg_0 -> ((Root)root).get(arg_0)).map((? super T e) -> e.as(String.class)).reduce((arg_0, arg_1) -> ((CriteriaBuilder)cb).concat(arg_0, arg_1)).orElse(null);
            query.select((Selection)cb.countDistinct(concatenatedPK));
        }
        query.where(this.withPredicates(query, filter, root, cb).toArray(new Predicate[0]));
        return query;
    }

    protected CriteriaQuery<E> getQueryByIds(CriteriaBuilder cb, F filter, List<K> orderedIds) {
        CriteriaQuery query = cb.createQuery(this.entityClass);
        Root root = query.from(this.entityClass);
        this.withFetch(query, root, filter);
        query.where((Expression)root.get(root.getModel().getId(this.keyClass)).in(orderedIds));
        return query;
    }

    protected void withFetch(CriteriaQuery<?> query, Root<E> root, F filter) {
    }

    protected List<Predicate> withPredicates(F filter, Root<E> root, CriteriaBuilder cb) {
        return Collections.emptyList();
    }

    protected List<Predicate> withPredicates(CriteriaQuery<?> query, F filter, Root<E> root, CriteriaBuilder cb) {
        return this.withPredicates(filter, root, cb);
    }

    protected <T> void withOrderBy(CriteriaBuilder cb, F filter, CriteriaQuery<?> query, Root<T> root) {
        this.withOrderBy(cb, filter, query, this.getOrderByFields(cb, filter, query, root));
    }

    protected <T> void withOrderBy(CriteriaBuilder cb, F filter, CriteriaQuery<?> query, List<Expression<?>> fields) {
        List orders = fields.stream().map((? super T orderExp) -> OrderDir.DESC == filter.getOrderDir() ? cb.desc(orderExp) : cb.asc(orderExp)).map((? super T o) -> {
            Boolean nullLast;
            Boolean bl = nullLast = filter.getOrderNullLast() != null ? filter.getOrderNullLast() : this.nullLastOrdering;
            if (nullLast != null) {
                return nullLast != false ? ((SqmSortSpecification)o).nullPrecedence(NullPrecedence.LAST) : ((SqmSortSpecification)o).nullPrecedence(NullPrecedence.FIRST);
            }
            return o;
        }).collect(Collectors.toList());
        if (!orders.isEmpty()) {
            query.orderBy(orders);
        }
    }

    protected <T> List<Expression<?>> getOrderByFields(CriteriaBuilder cb, F filter, CriteriaQuery<?> query, Root<T> root) {
        return this.getOrderByFields(cb, filter, query, root, false);
    }

    protected <T> List<Expression<?>> getOrderByFields(CriteriaBuilder cb, F filter, CriteriaQuery<?> query, Root<T> root, boolean withoutLeftJoins) {
        if (StringUtils.hasText((String)filter.getOrderBy())) {
            String[] orderByProps = StringUtils.tokenizeToStringArray((String)filter.getOrderBy(), (String)",", (boolean)true, (boolean)true);
            List<Expression<?>> orderByExpressions = Stream.of(orderByProps).map((? super T p) -> this.orderByExpression((String)p, root, cb, query, filter, withoutLeftJoins)).collect(Collectors.toList());
            if (this.appendOrderByPK && root.getModel().hasSingleIdAttribute()) {
                orderByExpressions.add((Expression<?>)root.get(root.getModel().getId(this.keyClass)));
            }
            return orderByExpressions;
        }
        return new ArrayList();
    }

    protected <T> Expression<?> orderByExpression(String p, Root<T> root, CriteriaBuilder cb, CriteriaQuery<?> query, F filter) {
        return this.orderByExpression(p, root, cb, query, filter, true);
    }

    protected <T> Expression<?> orderByExpression(String p, Root<T> root, CriteriaBuilder cb, CriteriaQuery<?> query, F filter, boolean withoutLeftJoins) {
        return withoutLeftJoins ? this.resolveFieldWithoutLeftJoin(p, root) : this.resolveField(p, root);
    }

    protected List<E> orderByGivenIds(List<E> result, List<K> ids) {
        result.sort(Comparator.comparing(e -> {
            int idx = ids.indexOf(e.key());
            return idx >= 0 ? idx : Integer.MAX_VALUE;
        }));
        return result;
    }

    protected List<K> getFirstColumnAsKey(List<Tuple> tuples) {
        return tuples.stream().map(this::getFirstColumnAsKey).collect(Collectors.toList());
    }

    protected K getFirstColumnAsKey(Tuple t) {
        return (K)t.get(0, this.keyClass);
    }
}

