/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.hibernate.repo.JpaWriteDao;
import inc.yukawa.chain.base.hibernate.util.MergingBeanUtilsBean;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HibernateReactiveWriteDao<K, E extends Keyed<K>>
implements JpaWriteDao<K, E> {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateReactiveWriteDao.class);
    protected Map<Class<?>, Function> keyExtractors = new HashMap();
    protected Map<MergingBeanUtilsBean.Strategy, MergingBeanUtilsBean> mergersCache = new ConcurrentHashMap<MergingBeanUtilsBean.Strategy, MergingBeanUtilsBean>();
    protected final Mutiny.SessionFactory sessionFactory;
    protected final Class<K> keyClass;
    protected final Class<E> entityClass;
    protected int queryTimeout = 60000;
    protected String mergeGraphName;
    protected String deleteGraphName;

    public HibernateReactiveWriteDao(Mutiny.SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.keyClass = ResolvableType.forInstance((Object)this).as(HibernateReactiveWriteDao.class).getGeneric(new int[]{0}).toClass();
        this.entityClass = ResolvableType.forInstance((Object)this).as(HibernateReactiveWriteDao.class).getGeneric(new int[]{1}).getRawClass();
    }

    public HibernateReactiveWriteDao(Mutiny.SessionFactory sessionFactory, String defaultGraphName) {
        this(sessionFactory);
        this.mergeGraphName = defaultGraphName;
        this.deleteGraphName = defaultGraphName;
    }

    public HibernateReactiveWriteDao(Mutiny.SessionFactory sessionFactory, String mergeGraphName, String deleteGraphName) {
        this(sessionFactory);
        this.mergeGraphName = mergeGraphName;
        this.deleteGraphName = deleteGraphName;
    }

    public HibernateReactiveWriteDao(Map<Class<?>, Function> keyExtractors, Mutiny.SessionFactory sessionFactory) {
        this(sessionFactory);
        this.keyExtractors = keyExtractors;
    }

    public void setGraphNames(String graphName) {
        this.mergeGraphName = graphName;
        this.deleteGraphName = graphName;
    }

    public void setMergeGraphName(String mergeGraphName) {
        this.mergeGraphName = mergeGraphName;
    }

    public void setDeleteGraphName(String deleteGraphName) {
        this.deleteGraphName = deleteGraphName;
    }

    @Override
    public Mono<E> create(E entity) {
        LOG.debug("[{}] create {}", (Object)this.getClass().getSimpleName(), entity);
        return (Mono)this.sessionFactory.withTransaction(session -> session.persist(entity).chain(() -> ((Mutiny.Session)session).flush()).replaceWith(entity)).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public <T extends Collection<E>> Mono<T> createMany(T entities) {
        LOG.debug("[{}] createMany: {} items", (Object)this.getClass().getSimpleName(), (Object)entities.size());
        return (Mono)this.sessionFactory.withTransaction(session -> session.persistAll(entities.toArray()).chain(() -> ((Mutiny.Session)session).flush()).replaceWith((Object)entities)).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public Mono<E> put(E entity) {
        LOG.debug("[{}] put {}", (Object)this.getClass().getSimpleName(), entity);
        return (Mono)this.sessionFactory.withTransaction(session -> session.merge(entity).onItem().call(() -> ((Mutiny.Session)session).flush())).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public <T extends Collection<E>> Mono<T> putMany(T entities) {
        LOG.debug("[{}] putMany: {} items", (Object)this.getClass().getSimpleName(), (Object)entities.size());
        return (Mono)this.sessionFactory.withTransaction(session -> session.mergeAll(entities.toArray()).chain(() -> ((Mutiny.Session)session).flush()).replaceWith((Object)entities)).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public Mono<E> update(E entity) {
        LOG.debug("[{}] update {}", (Object)this.getClass().getSimpleName(), entity);
        return (Mono)this.sessionFactory.withTransaction(session -> session.find(this.entityClass, entity.key()).onItem().ifNull().failWith(() -> this.notFound(entity)).flatMap(orig -> {
            if (entity instanceof Created) {
                ((Created)entity).setCreated(((Created)orig).getCreated());
            }
            return session.merge(entity);
        }).onItem().call(() -> ((Mutiny.Session)session).flush())).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public Mono<Integer> atomicMerge(E entity) {
        return this.atomicMerge(entity, this::applyAtomicMergeCriteria);
    }

    public Mono<Integer> atomicMerge(E entity, QuadConsumer<E, CriteriaUpdate<E>, Root<E>, CriteriaBuilder> criteriaApplier) {
        LOG.debug("[{}] atomicMerge {}", (Object)this.getClass().getSimpleName(), entity);
        Assert.notNull((Object)entity.key(), (String)"key");
        CriteriaBuilder cb = this.sessionFactory.getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(this.entityClass);
        Root root = update.from(this.entityClass);
        criteriaApplier.accept(entity, update, root, cb);
        return (Mono)this.sessionFactory.withTransaction(session -> session.createQuery(update).executeUpdate().ifNoItem().after(Duration.ofMillis(this.queryTimeout)).failWith(() -> new QueryTimeoutException("update timeout reached")).invoke(count -> {
            if (count == 0) {
                LOG.warn("no such entity " + entity.key() + "@" + this.entityClass.getSimpleName());
            } else if (count > 1) {
                LOG.warn("Updated {} records of {}. (more than one!!!???)", count, (Object)this.entityClass.getSimpleName());
            } else {
                LOG.debug("Updated {}@{} record", entity.key(), (Object)this.entityClass.getSimpleName());
            }
        })).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public Mono<E> merge(E entity) {
        LOG.debug("[{}] merge {}", (Object)this.getClass().getSimpleName(), entity);
        return this.merge(entity, (curr, orig) -> this.mergeProps(entity, orig, MergingBeanUtilsBean.Strategy.PUT));
    }

    @Override
    public Mono<E> mergeCollectionsAppend(E entity) {
        LOG.debug("[{}] mergeCollectionsAppend {}", (Object)this.getClass().getSimpleName(), entity);
        return this.merge(entity, (curr, orig) -> this.mergeProps(entity, orig, MergingBeanUtilsBean.Strategy.APPEND));
    }

    @Override
    public Mono<E> mergeCollectionsPut(E entity) {
        LOG.debug("[{}] mergeCollectionsPut {}", (Object)this.getClass().getSimpleName(), entity);
        return this.merge(entity, (curr, orig) -> this.mergeProps(entity, orig, MergingBeanUtilsBean.Strategy.PUT));
    }

    @Override
    public Mono<E> mergeCollectionsUpdate(E entity) {
        LOG.debug("[{}] mergeCollectionsUpdate {}", (Object)this.getClass().getSimpleName(), entity);
        return this.merge(entity, (curr, orig) -> this.mergeProps(entity, orig, MergingBeanUtilsBean.Strategy.UPDATE));
    }

    @Override
    public Mono<E> mergeCollectionsRemove(E entity) {
        LOG.debug("[{}] mergeCollectionsRemove {}", (Object)this.getClass().getSimpleName(), entity);
        return this.merge(entity, (curr, orig) -> this.mergeProps(entity, orig, MergingBeanUtilsBean.Strategy.REMOVE));
    }

    @Override
    public Mono<E> delete(E entity) {
        LOG.debug("[{}] delete {}", (Object)this.getClass().getSimpleName(), entity);
        return this.deleteByKey(entity.key());
    }

    @Override
    public <T extends Collection<E>> Mono<Void> deleteMany(T entities) {
        LOG.debug("[{}] deleteMany: {} items", (Object)this.getClass().getSimpleName(), (Object)entities.size());
        return (Mono)this.sessionFactory.withTransaction(session -> session.removeAll(entities.toArray()).chain(() -> ((Mutiny.Session)session).flush())).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public Mono<E> deleteByKey(K key) {
        LOG.debug("[{}] deleteByKey {}[{}]", new Object[]{this.getClass().getSimpleName(), this.entityClass.getSimpleName(), key});
        try {
            return (Mono)this.sessionFactory.withTransaction(session -> {
                EntityGraph<E> graph = this.graphForDelete((Mutiny.Session)session);
                Uni found = graph != null ? session.find(graph, key) : session.find(this.entityClass, key);
                return found.ifNoItem().after(Duration.ofMillis(this.queryTimeout)).failWith(() -> new QueryTimeoutException("load timeout reached")).onItem().ifNull().failWith(() -> this.notFoundKey(key)).chain(arg_0 -> ((Mutiny.Session)session).remove(arg_0));
            }).replaceWith((Object)((Keyed)this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).convert().with((Function)UniReactorConverters.toMono());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void applyAtomicMergeCriteria(E entity, CriteriaUpdate<E> update, Root<E> root, CriteriaBuilder cb) {
    }

    protected Mono<E> merge(E entity, BiFunction<E, E, E> merger) {
        return (Mono)this.sessionFactory.withTransaction(session -> {
            EntityGraph<E> graph = this.graphForMerge((Mutiny.Session)session);
            Uni found = graph != null ? session.find(graph, entity.key()) : session.find(this.entityClass, entity.key());
            return found.ifNoItem().after(Duration.ofMillis(this.queryTimeout)).failWith(() -> new QueryTimeoutException("load timeout reached")).onItem().ifNull().failWith(() -> this.notFound(entity)).chain(this::enrichLoaded).map(orig -> (Keyed)merger.apply(entity, orig)).flatMap(arg_0 -> ((Mutiny.Session)session).merge(arg_0)).onItem().call(() -> ((Mutiny.Session)session).flush());
        }).convert().with((Function)UniReactorConverters.toMono());
    }

    protected Uni<E> enrichLoaded(E entity) {
        return Uni.createFrom().item(entity);
    }

    protected E mergeProps(E source, E dest, MergingBeanUtilsBean.Strategy strategy) {
        MergingBeanUtilsBean merger = this.mergersCache.computeIfAbsent(strategy, s -> new MergingBeanUtilsBean((MergingBeanUtilsBean.Strategy)((Object)s), this.keyExtractors));
        try {
            merger.copyProperties(dest, source);
            return dest;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Merging error", (Throwable)e);
            throw new PersistenceException("Merging error", (Throwable)e);
        }
    }

    protected <T, X extends T> void setIfNotNull(CriteriaUpdate<E> update, SingularAttribute<? super E, T> attribute, Supplier<X> getter) {
        X val = getter.get();
        if (val != null) {
            update.set(attribute, val);
        }
    }

    protected EntityNotFoundException notFound(E entity) {
        return this.notFoundKey(entity.key());
    }

    protected EntityNotFoundException notFoundKey(K key) {
        return new EntityNotFoundException("no such entity " + key + "@" + this.entityClass.getSimpleName());
    }

    protected EntityGraph<E> graphForDelete(Mutiny.Session session) {
        return this.graphNameForDelete() != null ? session.getEntityGraph(this.entityClass, this.graphNameForDelete()) : this.graphForLoad(session);
    }

    protected EntityGraph<E> graphForMerge(Mutiny.Session session) {
        return this.graphNameForMerge() != null ? session.getEntityGraph(this.entityClass, this.graphNameForMerge()) : this.graphForLoad(session);
    }

    protected EntityGraph<E> graphForLoad(Mutiny.Session session) {
        return this.graphNameForLoad() != null ? session.getEntityGraph(this.entityClass, this.graphNameForLoad()) : null;
    }

    protected String graphNameForDelete() {
        return this.deleteGraphName;
    }

    protected String graphNameForMerge() {
        return this.mergeGraphName;
    }

    protected String graphNameForLoad() {
        return null;
    }

    @FunctionalInterface
    public static interface QuadConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }
}

