/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HibernateSequenceReadDao {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateSequenceReadDao.class);
    protected final Mutiny.SessionFactory sessionFactory;

    public HibernateSequenceReadDao(Mutiny.SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Mono<Integer> next(String sequenceName) {
        return this.next(sequenceName, 1).map(l -> (Integer)l.get(0));
    }

    public Mono<List<Integer>> next(String sequenceName, int count) {
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"count should be positive");
        LOG.debug("next: {}", (Object)sequenceName);
        return (Mono)this.sessionFactory.withStatelessSession(session -> session.createNativeQuery("select nextval('" + sequenceName + "') from generate_series(1," + count + ");", Number.class).getResultList().map(res -> res.stream().map(Number::intValue).collect(Collectors.toList())).invoke(ids -> LOG.debug("generated: {}", ids))).convert().with((Function)UniReactorConverters.toMono());
    }
}

