/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.HostStoreInfo;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import inc.yukawa.chain.base.hibernate.repo.JpaWriteDao;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class JpaRepo<K, E extends Keyed<K>, F>
implements CrudRepository<K, E, F> {
    protected final MonoReadDao<K, E, F> readDao;
    protected final JpaWriteDao<K, E> writeDao;
    protected final Supplier<Mono<String>> callerSupplier;
    protected Scheduler repoScheduler = Schedulers.newBoundedElastic((int)Schedulers.DEFAULT_BOUNDED_ELASTIC_SIZE, (int)Schedulers.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"repo");
    protected Scheduler vertxScheduler = Schedulers.fromExecutor(command -> Vertx.vertx().getOrCreateContext().runOnContext(v -> command.run()));

    public JpaRepo(MonoReadDao<K, E, F> readDao, JpaWriteDao<K, E> writeDao) {
        this(readDao, writeDao, null);
    }

    public JpaRepo(MonoReadDao<K, E, F> readDao, JpaWriteDao<K, E> writeDao, Supplier<Mono<String>> callerSupplier) {
        this.readDao = readDao;
        this.writeDao = writeDao;
        this.callerSupplier = callerSupplier;
    }

    public Mono<E> load(K key) {
        Objects.requireNonNull(key, "key");
        return this.readDao.load(key).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> read(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.read(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<Long> count(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.count(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<Map<K, E>> map(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.map(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Flux<E> find(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.find(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Flux<K> findKeys(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.findKeys(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<QueryResult<E>> query(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.query(filter).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> create(E entity) {
        Objects.requireNonNull(entity, "entity");
        return this.withChangedAndCreated((Collection)entity).flatMap(this.writeDao::create).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public <T extends Collection<E>> Mono<T> createMany(T entities) {
        Objects.requireNonNull(entities, "entities");
        return this.withChangedAndCreated(entities).flatMap(this.writeDao::createMany).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> put(E entity) {
        Objects.requireNonNull(entity, "value");
        return this.withChangedAndCreated((Collection)entity).flatMap(this.writeDao::put).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public <T extends Collection<E>> Mono<T> putMany(T entities) {
        Objects.requireNonNull(entities, "entities");
        return this.withChangedAndCreated(entities).flatMap(this.writeDao::putMany).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> update(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::update).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> merge(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::merge).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<Integer> atomicMerge(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::atomicMerge).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> mergeCollectionsAppend(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::mergeCollectionsAppend).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> mergeCollectionsPut(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::mergeCollectionsPut).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> mergeCollectionsUpdate(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::mergeCollectionsUpdate).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> mergeCollectionsRemove(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.withChangedAndClearedCreated(entity).flatMap(this.writeDao::mergeCollectionsRemove).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Flux<E> deleteByFilter(F filter) {
        return this.find(filter).concatMap(this::delete);
    }

    public Mono<E> delete(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.validateKey(entity, "entity.key");
        return this.writeDao.delete(entity).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public <T extends Collection<E>> Mono<Void> deleteMany(T entities) {
        Objects.requireNonNull(entities, "entities");
        return this.withChangedAndCreated(entities).flatMap(this.writeDao::deleteMany).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<E> deleteByKey(K key) {
        Objects.requireNonNull(key, "key");
        return this.writeDao.deleteByKey(key).publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    public Mono<Void> ping() {
        return ((HibernateReactiveReadDao)this.readDao).ping().publishOn(this.repoScheduler).cancelOn(this.vertxScheduler).cache(Duration.ofSeconds(0L));
    }

    protected Mono<E> withChangedAndClearedCreated(E entity) {
        return this.callerSupplier != null ? this.callerSupplier.get().switchIfEmpty(Mono.just((Object)"anonymous")).map(p -> {
            if (entity instanceof Created) {
                ((Created)entity).setCreated(null);
            }
            if (entity instanceof Changed) {
                ((Changed)entity).setChange(new Change(p, new Date()));
            }
            return entity;
        }) : Mono.just(entity);
    }

    protected Mono<E> withChangedAndCreated(E entity) {
        return this.withChangedAndCreated((Collection)Collections.singletonList(entity)).flatMap(l -> Mono.justOrEmpty(l.stream().findFirst()));
    }

    protected <T extends Collection<E>> Mono<T> withChangedAndCreated(T entities) {
        return this.callerSupplier != null ? this.callerSupplier.get().switchIfEmpty(Mono.just((Object)"anonymous")).map(p -> {
            Date date = new Date();
            entities.forEach(entity -> {
                if (entity instanceof Created) {
                    ((Created)entity).setCreated(new Change(p, date));
                }
                if (entity instanceof Changed) {
                    ((Changed)entity).setChange(new Change(p, date));
                }
            });
            return entities;
        }) : Mono.just(entities);
    }

    public Flux<HostStoreInfo> meta() {
        return null;
    }

    private void validateKey(E entity, String s) {
        Objects.requireNonNull(entity.key(), s);
        if (entity.key() instanceof String) {
            Assert.isTrue((boolean)StringUtils.hasText((String)((String)entity.key())), (String)("value.key must have some non whitespace char, but was: '" + entity.key() + "'"));
        }
    }
}

