/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.util;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;

public class MergingBeanUtilsBean
extends BeanUtilsBean {
    private Strategy strategy = Strategy.UPDATE;
    private Map<Class<?>, Function> keyExtractors = new HashMap();

    public MergingBeanUtilsBean() {
    }

    public MergingBeanUtilsBean(Strategy strategy) {
        this.strategy = strategy;
    }

    public MergingBeanUtilsBean(Strategy strategy, Map<Class<?>, Function> keyExtractors) {
        this.strategy = strategy;
        this.keyExtractors = keyExtractors;
    }

    public void copyProperty(Object dest, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection destValue = (Collection)this.getValue(dest, name);
            Collection merged = this.merge((Collection)value, destValue, this.strategy);
            super.copyProperty(dest, name, (Object)merged);
        } else if (value instanceof Object[]) {
            Object[] destValue = (Object[])this.getValue(dest, name);
            Object[] merged = this.merge((Object[])value, destValue, this.strategy);
            super.copyProperty(dest, name, (Object)merged);
        } else {
            super.copyProperty(dest, name, value);
        }
    }

    private Collection merge(Collection source, Collection dest, Strategy strategy) {
        if (dest == null) {
            if (strategy == Strategy.REMOVE || strategy == Strategy.UPDATE) {
                return dest;
            }
            return source;
        }
        switch (strategy) {
            case APPEND: {
                dest.addAll(source);
                break;
            }
            case PUT: {
                dest.clear();
                dest.addAll(source);
                break;
            }
            case UPDATE: {
                Map toUpdate = source.stream().collect(Collectors.toMap(this::keyOf, Function.identity()));
                toUpdate.keySet().retainAll(dest.stream().map(this::keyOf).collect(Collectors.toSet()));
                if (dest instanceof List) {
                    ((List)dest).replaceAll(o -> {
                        if (this.keyOf(o) != null && toUpdate.containsKey(this.keyOf(o))) {
                            return toUpdate.get(this.keyOf(o));
                        }
                        return o;
                    });
                    break;
                }
                dest.removeIf(c -> toUpdate.containsKey(this.keyOf(c)));
                dest.addAll(source);
                break;
            }
            case REMOVE: {
                Set toRemove = source.stream().map(this::keyOf).collect(Collectors.toSet());
                dest.removeIf(c -> toRemove.contains(this.keyOf(c)));
                break;
            }
        }
        return dest;
    }

    private Object[] merge(Object[] source, Object[] dest, Strategy strategy) {
        List<Object> destAsCollection = dest != null ? Arrays.asList(dest) : null;
        Collection merged = this.merge(Arrays.asList(source), destAsCollection, strategy);
        return merged != null ? merged.toArray() : null;
    }

    protected Object keyOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.keyExtractors.containsKey(obj.getClass())) {
            return this.keyExtractors.get(obj.getClass()).apply(obj);
        }
        if (obj instanceof Keyed) {
            return ((Keyed)obj).key();
        }
        return obj;
    }

    private Object getValue(Object dest, String name) throws InvocationTargetException, IllegalAccessException {
        try {
            return this.getPropertyUtils().getSimpleProperty(dest, name);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static enum Strategy {
        APPEND,
        UPDATE,
        REMOVE,
        PUT;

    }
}

