/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.config;

import com.fasterxml.jackson.datatype.hibernate7.Hibernate7Module;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.reactive.mutiny.Mutiny;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public abstract class HibernateConfigBase {
    public Map<String, String> properties = new HashMap<String, String>();
    @Value(value="${chain.hibernate.persistenceUnit:chainPU}")
    public String persistenceUnit;

    @Bean
    public Hibernate7Module hibernateModule() {
        return new Hibernate7Module();
    }

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.persistenceUnit, this.getProperties());
    }

    @Bean
    public Mutiny.SessionFactory sessionFactory(EntityManagerFactory emf) {
        return (Mutiny.SessionFactory)emf.unwrap(Mutiny.SessionFactory.class);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

