/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.repo;

import inc.yukawa.chain.base.core.domain.range.DataRange;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.reactive.mutiny.Mutiny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class HibernateReactiveDao {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateReactiveDao.class);
    public static final String ORDER_BY_DELIMITER = ",";
    protected final Mutiny.SessionFactory sessionFactory;
    protected int defaultMaxResults = 10000;
    protected int queryTimeout = 60000;
    protected boolean countingEnabled = true;
    protected boolean appendOrderByPK = true;
    protected boolean enableLeftJoinsForPathsResolutions = true;
    protected boolean reuseFetchJoinsForPathsResolutions = true;

    public HibernateReactiveDao(Mutiny.SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public static String escapeRegexpChars(String phrase) {
        if (phrase == null) {
            return null;
        }
        phrase = phrase.replace("\\", "\\\\");
        phrase = phrase.replace(".", "\\.");
        phrase = phrase.replace("+", "\\+");
        phrase = phrase.replace("*", "\\*");
        phrase = phrase.replace("?", "\\?");
        phrase = phrase.replace("^", "\\^");
        phrase = phrase.replace("$", "\\$");
        phrase = phrase.replace("(", "\\(");
        phrase = phrase.replace(")", "\\)");
        phrase = phrase.replace("[", "\\[");
        phrase = phrase.replace("]", "\\]");
        phrase = phrase.replace("{", "\\{");
        phrase = phrase.replace("}", "\\}");
        phrase = phrase.replace("|", "\\|");
        return phrase;
    }

    public Mono<Void> ping() {
        return ((Mono)this.sessionFactory.withStatelessSession(s -> s.createNativeQuery("SELECT 1").getSingleResult()).ifNoItem().after(Duration.ofMillis(this.queryTimeout)).failWith(() -> new QueryTimeoutException("query timeout reached")).convert().with((Function)UniReactorConverters.toMono())).then();
    }

    protected <T> Expression<?> resolveFieldWithoutLeftJoin(String propPath, Root<T> root) {
        String[] props = propPath.split("\\.");
        Path result = root;
        for (String prop : props) {
            result = result.get(prop);
        }
        return result;
    }

    protected <T> Expression<?> resolveField(String propPath, Root<T> root) {
        return this.resolveFields(new String[]{propPath}, root).get(0);
    }

    protected <T> List<Expression<?>> resolveFields(String[] propPaths, Root<T> root) {
        return this.resolvePaths(Arrays.asList(propPaths), (Path<T>)root).stream().map(v -> v).collect(Collectors.toList());
    }

    protected <T> List<Path<?>> resolvePaths(List<String> paths, Path<T> parent) {
        if (paths == null || paths.isEmpty() || paths.stream().allMatch(java.util.function.Predicate.not(StringUtils::hasText))) {
            return new ArrayList(List.of(parent));
        }
        Map groupedByCommonPrefix = paths.stream().filter(StringUtils::hasText).map(path -> path.split("\\.", 2)).collect(Collectors.groupingBy(p -> p[0], TreeMap::new, Collectors.mapping(p -> ((String[])p).length > 1 ? p[1] : null, Collectors.toList())));
        return groupedByCommonPrefix.entrySet().stream().map(e -> this.resolvePaths((List)e.getValue(), this.resolveSubPath((String)e.getKey(), parent))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected <T> Path<?> resolveSubPath(String subPath, Path<T> parent) {
        if (!StringUtils.hasText((String)subPath)) {
            return parent;
        }
        Assert.isTrue((!subPath.contains(".") ? 1 : 0) != 0, (String)"attribute can't contain a dot");
        if (this.enableLeftJoinsForPathsResolutions && parent instanceof AbstractSqmFrom) {
            boolean isInnerFetched;
            AbstractSqmFrom from = (AbstractSqmFrom)parent;
            if (this.reuseFetchJoinsForPathsResolutions && (isInnerFetched = from.getFetches().stream().anyMatch(f -> subPath.equals(f.getAttribute().getName()) && JoinType.INNER == f.getJoinType()))) {
                return parent.get(subPath);
            }
            SqmPathSource subPathSource = from.getReferencedPathSource().getSubPathSource(subPath);
            if (subPathSource.getSqmType() instanceof ManagedDomainType) {
                return from.join(subPath, JoinType.LEFT);
            }
        }
        return parent.get(subPath);
    }

    protected void whereEquals(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<?> getter) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(cb.equal(field, filterValue));
        }
    }

    protected void whereEqualsIgnoreCase(List<Predicate> predicates, CriteriaBuilder cb, Expression<String> field, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(cb.equal(cb.upper(field), (Object)filterValue.toUpperCase()));
        }
    }

    protected void whereNotEquals(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<?> getter) {
        Object filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(cb.equal(field, filterValue).not());
        }
    }

    protected <T> void whereIn(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<Collection<T>> getter) {
        Collection<T> filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(field.in(filterValue));
        }
    }

    protected <T> void whereNotIn(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<Collection<T>> getter) {
        Collection<T> filterValue = getter.get();
        if (filterValue != null && !filterValue.isEmpty()) {
            predicates.add(field.in(filterValue).not());
        }
    }

    protected void whereLike(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(cb.like(field.cast(String.class), filterValue));
        }
    }

    protected void whereNotLike(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            predicates.add(cb.like(field.cast(String.class), filterValue).not());
        }
    }

    protected void whereNull(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field) {
        this.whereNull(predicates, cb, field, () -> true);
    }

    protected void whereNull(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<Boolean> getter) {
        Boolean filterValue = getter.get();
        if (filterValue != null) {
            if (filterValue.booleanValue()) {
                predicates.add(cb.isNull(field));
            } else {
                predicates.add(cb.isNotNull(field));
            }
        }
    }

    protected void whereNotNull(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field) {
        this.whereNotNull(predicates, cb, field, () -> true);
    }

    protected void whereNotNull(List<Predicate> predicates, CriteriaBuilder cb, Expression<?> field, Supplier<Boolean> getter) {
        Boolean filterValue = getter.get();
        if (filterValue != null) {
            if (filterValue.booleanValue()) {
                predicates.add(cb.isNotNull(field));
            } else {
                predicates.add(cb.isNull(field));
            }
        }
    }

    protected <T extends Comparable<? super T>> void whereBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<DataRange<T>> getter) {
        this.whereBetween(predicates, cb, field, getter, false, true);
    }

    protected <T extends Comparable<? super T>> void whereNotBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<DataRange<T>> getter) {
        this.whereNotBetween(predicates, cb, field, getter, false, true);
    }

    protected <T extends Comparable<? super T>> void whereBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<DataRange<T>> getter, boolean startRangeOpen, boolean endRangeOpen) {
        DataRange<T> range = getter.get();
        this.whereBetween(predicates, cb, field, range != null ? () -> range.getFrom() : () -> null, range != null ? () -> range.getTo() : () -> null, startRangeOpen, endRangeOpen);
    }

    protected <T extends Comparable<? super T>> void whereNotBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<DataRange<T>> getter, boolean startRangeOpen, boolean endRangeOpen) {
        DataRange<T> range = getter.get();
        this.whereNotBetween(predicates, cb, field, range != null ? () -> range.getFrom() : () -> null, range != null ? () -> range.getTo() : () -> null, startRangeOpen, endRangeOpen);
    }

    protected <T extends Comparable<? super T>> void whereBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<T> fromGetter, Supplier<T> toGetter, boolean startRangeOpen, boolean endRangeOpen) {
        if (fromGetter.get() != null) {
            predicates.add(startRangeOpen ? cb.greaterThan(field, (Comparable)fromGetter.get()) : cb.greaterThanOrEqualTo(field, (Comparable)fromGetter.get()));
        }
        if (toGetter.get() != null) {
            predicates.add(endRangeOpen ? cb.lessThan(field, (Comparable)toGetter.get()) : cb.lessThanOrEqualTo(field, (Comparable)toGetter.get()));
        }
    }

    protected <T extends Comparable<? super T>> void whereNotBetween(List<Predicate> predicates, CriteriaBuilder cb, Expression<T> field, Supplier<T> fromGetter, Supplier<T> toGetter, boolean startRangeOpen, boolean endRangeOpen) {
        if (fromGetter.get() != null) {
            predicates.add(startRangeOpen ? cb.greaterThan(field, (Comparable)fromGetter.get()).not() : cb.greaterThanOrEqualTo(field, (Comparable)fromGetter.get()).not());
        }
        if (toGetter.get() != null) {
            predicates.add(endRangeOpen ? cb.lessThan(field, (Comparable)toGetter.get()).not() : cb.lessThanOrEqualTo(field, (Comparable)toGetter.get()).not());
        }
    }

    protected <T> void whereKeyword(List<Predicate> predicates, CriteriaBuilder cb, String[] searchFields, Root<T> root, Supplier<String> getter) {
        this.whereKeyword(predicates, cb, this.resolveFields(searchFields, root), getter);
    }

    protected void whereKeyword(List<Predicate> predicates, CriteriaBuilder cb, List<Expression<?>> fields, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            String exp = this.keywordAsLikeExpression(filterValue);
            LOG.debug("[{}] Keyword as like expression: {}", (Object)this.getClass().getSimpleName(), (Object)exp);
            ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
            for (Expression<?> field : fields) {
                restrictions.add(cb.like(cb.lower(field.cast(String.class)), exp, '\\'));
            }
            predicates.add(cb.or(restrictions.toArray(new Predicate[0])));
        }
    }

    protected String keywordAsLikeExpression(String keyword) {
        String exp = keyword.toLowerCase();
        exp = exp.replaceAll("\\\\", Matcher.quoteReplacement("\\"));
        exp = exp.replaceAll("%", Matcher.quoteReplacement("\\%"));
        exp = exp.replaceAll("\\*", "%");
        return exp;
    }

    protected <T> void whereKeywordRegexp(List<Predicate> predicates, CriteriaBuilder cb, String[] searchFields, Root<T> root, Supplier<String> getter) {
        this.whereKeywordRegexp(predicates, cb, this.resolveFields(searchFields, root), getter);
    }

    protected void whereKeywordRegexp(List<Predicate> predicates, CriteriaBuilder cb, List<Expression<?>> fields, Supplier<String> getter) {
        String filterValue = getter.get();
        if (filterValue != null) {
            String exp = filterValue;
            LOG.debug("[{}] Keyword as regexp expression: {}", (Object)this.getClass().getSimpleName(), (Object)exp);
            ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
            for (Expression<?> field : fields) {
                restrictions.add(cb.isTrue(cb.function("regexp", Boolean.class, new Expression[]{field.cast(String.class), cb.literal((Object)exp)})));
            }
            predicates.add(cb.or(restrictions.toArray(new Predicate[0])));
        }
    }

    public boolean isAppendOrderByPK() {
        return this.appendOrderByPK;
    }

    public void setAppendOrderByPK(boolean appendOrderByPK) {
        this.appendOrderByPK = appendOrderByPK;
    }

    public boolean isEnableLeftJoinsForPathsResolutions() {
        return this.enableLeftJoinsForPathsResolutions;
    }

    public void setEnableLeftJoinsForPathsResolutions(boolean enableLeftJoinsForPathsResolutions) {
        this.enableLeftJoinsForPathsResolutions = enableLeftJoinsForPathsResolutions;
    }

    public boolean isReuseFetchJoinsForPathsResolutions() {
        return this.reuseFetchJoinsForPathsResolutions;
    }

    public void setReuseFetchJoinsForPathsResolutions(boolean reuseFetchJoinsForPathsResolutions) {
        this.reuseFetchJoinsForPathsResolutions = reuseFetchJoinsForPathsResolutions;
    }
}

