/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.hibernate.util;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingBeanUtilsBean
extends BeanUtilsBean {
    private static final Logger LOG = LoggerFactory.getLogger(MergingBeanUtilsBean.class);
    private Strategy strategy = Strategy.UPDATE;
    private Map<Class<?>, Function> keyExtractors = new HashMap();
    private boolean clearOnSpecialValues;
    private String clearStringValue;
    private Number clearNumberValue;
    private Instant clearDateValue;
    private LocalTime clearTimeValue;
    private List<String> skippedProps = new ArrayList<String>();

    public MergingBeanUtilsBean() {
    }

    public MergingBeanUtilsBean(Strategy strategy) {
        this.strategy = strategy;
    }

    public MergingBeanUtilsBean(Strategy strategy, Map<Class<?>, Function> keyExtractors) {
        this.strategy = strategy;
        this.keyExtractors = keyExtractors;
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        Map originalSkippedProps = this.skippedProps.stream().filter(p -> PropertyUtils.isReadable((Object)dest, (String)p)).collect(Collectors.toMap(Function.identity(), nestedPropertyName -> {
            try {
                return PropertyUtils.getProperty((Object)dest, (String)nestedPropertyName);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }));
        super.copyProperties(dest, orig);
        originalSkippedProps.forEach((nestedPropertyName, originalValue) -> {
            try {
                PropertyUtils.setProperty((Object)dest, (String)nestedPropertyName, (Object)originalValue);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void copyProperty(Object dest, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection destValue = (Collection)this.getValue(dest, name);
            Collection merged = this.merge((Collection)value, destValue, this.strategy);
            super.copyProperty(dest, name, (Object)merged);
        } else if (value instanceof Object[]) {
            Object[] destValue = (Object[])this.getValue(dest, name);
            Object[] merged = this.merge((Object[])value, destValue, this.strategy);
            super.copyProperty(dest, name, (Object)merged);
        } else if (this.clearOnSpecialValues) {
            boolean clearAsTime;
            boolean clearAsString = value instanceof String && this.clearStringValue != null && this.clearStringValue.equalsIgnoreCase((String)value);
            boolean clearAsNumber = value instanceof Number && this.clearNumberValue != null && this.clearNumberValue.intValue() == ((Number)value).intValue();
            boolean clearAsTemporal = value instanceof Temporal && this.clearDateValue != null && this.isCloseToDateClearValue(this.clearDateValue, (Temporal)value);
            boolean clearAsDate = value instanceof Date && this.clearDateValue != null && this.isCloseToDateClearValue(this.clearDateValue, ((Date)value).toInstant());
            boolean bl = clearAsTime = (value instanceof LocalTime || value instanceof OffsetTime) && this.clearTimeValue != null && this.isCloseToTimeClearValue(this.clearTimeValue, (Temporal)value);
            if (clearAsString || clearAsNumber || clearAsTemporal || clearAsDate || clearAsTime) {
                LOG.debug("Clearing property value {} as desired value {} is special clear value", (Object)name, value);
                super.copyProperty(dest, name, null);
            } else {
                super.copyProperty(dest, name, value);
            }
        } else {
            super.copyProperty(dest, name, value);
        }
    }

    private Collection merge(Collection source, Collection dest, Strategy strategy) {
        if (dest == null) {
            if (strategy == Strategy.REMOVE || strategy == Strategy.UPDATE) {
                return dest;
            }
            return source;
        }
        switch (strategy) {
            case APPEND: {
                dest.addAll(source);
                break;
            }
            case PUT: {
                dest.clear();
                dest.addAll(source);
                break;
            }
            case UPDATE: {
                Map toUpdate = source.stream().collect(Collectors.toMap(this::keyOf, Function.identity()));
                toUpdate.keySet().retainAll(dest.stream().map(this::keyOf).collect(Collectors.toSet()));
                if (dest instanceof List) {
                    ((List)dest).replaceAll(o -> {
                        if (this.keyOf(o) != null && toUpdate.containsKey(this.keyOf(o))) {
                            return toUpdate.get(this.keyOf(o));
                        }
                        return o;
                    });
                    break;
                }
                dest.removeIf(c -> toUpdate.containsKey(this.keyOf(c)));
                dest.addAll(source);
                break;
            }
            case REMOVE: {
                Set toRemove = source.stream().map(this::keyOf).collect(Collectors.toSet());
                dest.removeIf(c -> toRemove.contains(this.keyOf(c)));
                break;
            }
        }
        return dest;
    }

    private Object[] merge(Object[] source, Object[] dest, Strategy strategy) {
        List<Object> destAsCollection = dest != null ? Arrays.asList(dest) : null;
        Collection merged = this.merge(Arrays.asList(source), destAsCollection, strategy);
        return merged != null ? merged.toArray() : null;
    }

    protected Object keyOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.keyExtractors.containsKey(obj.getClass())) {
            return this.keyExtractors.get(obj.getClass()).apply(obj);
        }
        if (obj instanceof Keyed) {
            return ((Keyed)obj).key();
        }
        return obj;
    }

    private Object getValue(Object dest, String name) throws InvocationTargetException, IllegalAccessException {
        try {
            return this.getPropertyUtils().getSimpleProperty(dest, name);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e);
        }
    }

    private boolean isCloseToDateClearValue(Instant clearValue, Temporal value) {
        ChronoZonedDateTime<LocalDate> zonedDateTime = null;
        if (value instanceof Instant) {
            zonedDateTime = ((Instant)value).atZone(ZoneOffset.UTC);
        } else if (value instanceof ChronoLocalDate) {
            zonedDateTime = ((ChronoLocalDate)value).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else if (value instanceof ChronoLocalDateTime) {
            zonedDateTime = ((ChronoLocalDateTime)value).atZone(ZoneOffset.UTC);
        } else if (value instanceof OffsetDateTime) {
            zonedDateTime = ((OffsetDateTime)value).atZoneSameInstant(ZoneOffset.UTC);
        } else if (value instanceof Year) {
            zonedDateTime = ((Year)value).atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else if (value instanceof YearMonth) {
            zonedDateTime = ((YearMonth)value).atDay(1).atTime(LocalTime.MIN).atZone(ZoneOffset.UTC);
        } else if (value instanceof ChronoZonedDateTime) {
            zonedDateTime = (ChronoZonedDateTime)value;
        }
        return zonedDateTime != null && zonedDateTime.toEpochSecond() == clearValue.getEpochSecond();
    }

    private boolean isCloseToTimeClearValue(LocalTime clearValue, Temporal value) {
        if (value instanceof LocalTime) {
            return ((LocalTime)value).toSecondOfDay() == clearValue.toSecondOfDay();
        }
        if (value instanceof OffsetTime) {
            return ((OffsetTime)value).toLocalTime().toSecondOfDay() == clearValue.toSecondOfDay();
        }
        return false;
    }

    public void setClearOnSpecialValues(boolean clearOnSpecialValues) {
        this.clearOnSpecialValues = clearOnSpecialValues;
    }

    public void setClearStringValue(String clearStringValue) {
        this.clearStringValue = clearStringValue;
    }

    public void setClearNumberValue(Number clearNumberValue) {
        this.clearNumberValue = clearNumberValue;
    }

    public void setClearDateValue(Instant clearDateValue) {
        this.clearDateValue = clearDateValue;
    }

    public void setClearTimeValue(LocalTime clearTimeValue) {
        this.clearTimeValue = clearTimeValue;
    }

    public void setSkippedProps(List<String> skippedProps) {
        this.skippedProps = skippedProps;
    }

    public static enum Strategy {
        APPEND,
        UPDATE,
        REMOVE,
        PUT;

    }
}

