/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.info.InfoFilter;
import inc.yukawa.chain.base.core.domain.media.File;
import inc.yukawa.chain.base.core.domain.media.FileFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.reactive.mutiny.Mutiny;
import org.springframework.stereotype.Repository;

@Repository
public class FileReadDao
extends HibernateReactiveReadDao<Integer, File, FileFilter> {
    public FileReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected void withFetch(CriteriaQuery<?> query, Root<File> root, FileFilter filter) {
        if (Boolean.TRUE.equals(filter.getFetchBody())) {
            root.fetch("body");
        }
    }

    protected List<Predicate> withPredicates(FileFilter filter, Root<File> root, CriteriaBuilder cb) {
        ChangeFilter changeFilter;
        ChangeFilter createdFilter;
        InfoFilter infoFilter;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("fileId"), () -> ((FileFilter)filter).getFileId());
        this.whereIn(predicates, cb, (Expression)root.get("fileId"), () -> ((FileFilter)filter).getFileIds());
        this.whereEquals(predicates, cb, (Expression)root.get("mime"), () -> ((FileFilter)filter).getMime());
        this.whereEquals(predicates, cb, (Expression)root.get("category"), () -> ((FileFilter)filter).getCategory());
        this.whereEquals(predicates, cb, (Expression)root.get("position"), () -> ((FileFilter)filter).getPosition());
        ChainKey relatedFilter = filter.getRelated();
        if (relatedFilter != null) {
            Path relatedPath = root.get("related");
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("module"), () -> ((ChainKey)relatedFilter).getModule());
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("entity"), () -> ((ChainKey)relatedFilter).getEntity());
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("id"), () -> ((ChainKey)relatedFilter).getId());
            this.whereIn(predicates, cb, (Expression)relatedPath.get("id"), () -> ((FileFilter)filter).getRelatedIds());
        }
        if ((infoFilter = filter.getInfo()) != null) {
            Path infoPath = root.get("info");
            this.whereEquals(predicates, cb, (Expression)infoPath.get("id"), () -> ((InfoFilter)infoFilter).getId());
            this.whereEquals(predicates, cb, (Expression)infoPath.get("name"), () -> ((InfoFilter)infoFilter).getName());
            this.whereEquals(predicates, cb, (Expression)infoPath.get("shortName"), () -> ((InfoFilter)infoFilter).getShortName());
            this.whereLike(predicates, cb, (Expression)infoPath.get("desc"), () -> ((InfoFilter)infoFilter).getDesc());
        }
        if ((createdFilter = filter.getCreated()) != null) {
            Path createdPath = root.get("created");
            this.whereEquals(predicates, cb, (Expression)createdPath.get("user"), () -> ((ChangeFilter)createdFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)createdPath.get("date"), () -> ((ChangeFilter)createdFilter).getDate());
        }
        if ((changeFilter = filter.getChange()) != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        return predicates;
    }
}

