/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.media.Image;
import inc.yukawa.chain.base.core.domain.media.ImageBody;
import inc.yukawa.chain.base.core.domain.media.ImageFilter;
import inc.yukawa.chain.base.core.domain.media.ImageSize;
import inc.yukawa.chain.base.media.ImageService;
import inc.yukawa.chain.base.rest.ctrl.RepoAspectRest;
import inc.yukawa.chain.base.service.RepoAspect;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Api(value="Image", tags={"Image"})
@RestController
@RequestMapping(path={"/image"}, produces={"application/json", "text/xml"})
@Validated
public class ImageRest
extends RepoAspectRest<Integer, Image, ImageFilter> {
    @Value(value="${chain.media.thumbnail.cache.maxAge:P30D}")
    private Duration cacheMaxAge;
    private static final Logger LOG = LoggerFactory.getLogger(ImageRest.class);
    private final Tika tika = new Tika();

    public ImageRest(ImageService aspect) {
        super((RepoAspect)aspect);
    }

    @GetMapping(value={"/urls"})
    @ApiOperation(value="urls")
    public Mono<Map<String, List<String>>> urls(@RequestParam(value="relatedModule") String module, @RequestParam(value="relatedEntity") String entity, @RequestParam(value="relatedId") @ApiParam String id) {
        return this.urls(new ChainKey(module, entity, id));
    }

    @PostMapping(value={"/urls"})
    @ApiOperation(value="urls")
    public Mono<Map<String, List<String>>> urls(@RequestBody ChainKey chainKey) {
        LOG.info("[{}] urls: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)chainKey);
        return ((ImageService)this.aspect).getUrls(chainKey);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @ApiOperation(value="upload", notes="Upload a new image and associated metadata")
    public Mono<Image> upload(@RequestPart(value="image", required=false) Image image, @RequestPart(value="file") Mono<FilePart> file) {
        LOG.info("[{}] upload for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)image);
        if (image == null) {
            image = new Image();
        }
        return ((ImageService)this.aspect).saveImage(image, file);
    }

    @PostMapping(value={"/uploadMainImage"}, consumes={"multipart/form-data"})
    @ApiOperation(value="uploadMainImage", notes="Upload a new image for 'related' object into 'main' category, removing all previous ones. The `related` property is mandatory")
    public Mono<Image> uploadMainImage(@RequestPart(value="image") Image image, @RequestPart(value="file") Mono<FilePart> file) {
        LOG.info("[{}] uploadMainImage for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)image);
        return ((ImageService)this.aspect).saveMainImage(image.getRelated(), file);
    }

    @PostMapping(value={"/uploadMainImageByRelated"}, consumes={"multipart/form-data"})
    @ApiOperation(value="uploadMainImageByRelated", notes="Upload a new image for 'related' object into 'main' category, removing all previous ones")
    public Mono<Image> uploadMainImageByRelated(@RequestParam(value="relatedEntity") String relatedEntity, @RequestParam(value="relatedModule") String relatedModule, @RequestParam(value="relatedId") String relatedId, @RequestPart(value="file") Mono<FilePart> file) {
        ChainKey related = new ChainKey(relatedModule, relatedEntity, relatedId);
        LOG.info("[{}] uploadMainImageByRelated for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)related);
        return ((ImageService)this.aspect).saveMainImage(related, file);
    }

    @PostMapping(value={"/appendImage"}, consumes={"multipart/form-data"})
    @ApiOperation(value="appendImage", notes="Appends a new image for 'related' object into given category to the end of the list of existing images in same category. The `related` property is mandatory")
    public Mono<Image> appendImage(@RequestPart(value="image") Image image, @RequestPart(value="file") Mono<FilePart> file) {
        LOG.info("[{}] appendImage for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)image);
        return ((ImageService)this.aspect).appendImage(image.getRelated(), image.getCategory(), file);
    }

    @PostMapping(value={"/download"}, produces={"*/*"})
    @ApiOperation(value="download", response=Resource.class)
    public Mono<ResponseEntity<Resource>> download(@RequestBody ImageFilter filter, ServerWebExchange exchange) {
        LOG.info("[{}] download for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)filter);
        return ((ImageService)this.aspect).download(filter).map(tuple2 -> {
            if (exchange.checkNotModified(((Date)tuple2.getT2()).toInstant())) {
                return ResponseEntity.status((int)304).build();
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)this.tika.detect(((ImageBody)tuple2.getT1()).getData()))).cacheControl(CacheControl.maxAge((long)this.cacheMaxAge.getSeconds(), (TimeUnit)TimeUnit.SECONDS).cachePublic())).body((Object)new ByteArrayResource(((ImageBody)tuple2.getT1()).getData()));
        }).switchIfEmpty(Mono.just((Object)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).build()));
    }

    @GetMapping(value={"/download"}, produces={"*/*"})
    @ApiOperation(value="download", response=Resource.class)
    public Mono<ResponseEntity<Resource>> download(@RequestParam(value="imageId", required=false) Integer imageId, @RequestParam(value="size", required=false) ImageSize fetchBody, @RequestParam(value="relatedModule", required=false) String relatedModule, @RequestParam(value="relatedEntity", required=false) String relatedEntity, @RequestParam(value="relatedId", required=false) String relatedId, @RequestParam(value="category", required=false) String category, @RequestParam(value="position", required=false) Integer position, ServerWebExchange exchange) {
        ImageFilter f = new ImageFilter();
        f.setImageId(imageId);
        f.setFetchBody(fetchBody);
        if (relatedModule != null || relatedEntity != null || relatedId != null) {
            f.setRelated(new ChainKey(relatedModule, relatedEntity, relatedId));
        }
        f.setCategory(category);
        f.setPosition(position);
        return this.download(f, exchange);
    }
}

