/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.entity.Imaged;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.media.ImageService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class ImageUrlsSupport<E extends Imaged & Keyed<?>> {
    private final String module;
    private final String entity;
    private final ImageService imageService;

    public ImageUrlsSupport(String module, String entity, ImageService imageService) {
        this.module = module;
        this.entity = entity;
        this.imageService = imageService;
    }

    public Mono<E> enhance(E entity) {
        return this.enhance(Collections.singletonList(entity)).thenReturn(entity);
    }

    public Mono<List<E>> enhance(List<E> entities) {
        if (entities.isEmpty()) {
            return Mono.just(entities);
        }
        Map<String, List<Imaged>> byId = entities.stream().collect(Collectors.groupingBy(e -> Objects.toString(((Keyed)e).key())));
        return this.imageService.getUrls(this.module, this.entity, byId.keySet()).flatMap(res -> {
            res.forEach((chainKey, imageUrls) -> {
                List el = (List)byId.get(chainKey.getId());
                if (el != null) {
                    el.forEach(e -> e.setImageUrls(imageUrls));
                }
            });
            return Mono.just((Object)entities);
        });
    }
}

