/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.media.File;
import inc.yukawa.chain.base.core.domain.media.FileBody;
import inc.yukawa.chain.base.core.domain.media.FileFilter;
import inc.yukawa.chain.base.core.filter.Pager;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.media.UploadService;
import inc.yukawa.chain.base.service.InterceptedRepoAspect;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import reactor.core.publisher.Mono;

@Service
@Validated
public class FileService
extends InterceptedRepoAspect<Integer, File, FileFilter> {
    private final UploadService uploadService;

    public FileService(JpaRepo<Integer, File, FileFilter> repo, UploadService uploadService) {
        super(repo);
        this.uploadService = uploadService;
    }

    public Mono<File> saveFile(File file, Mono<FilePart> fileBody) {
        return fileBody.flatMap(this.uploadService::toBody).zipWith(this.put((Keyed)file), (t3, f) -> {
            f.setBody(new FileBody(f.getFileId(), (byte[])t3.getT1()));
            f.setSize(Long.valueOf(((byte[])t3.getT1()).length));
            if (f.getInfo() == null) {
                f.setInfo(new Info());
            }
            if (f.getInfo().getName() == null) {
                f.getInfo().setName((String)t3.getT2());
            }
            if (f.getMime() == null) {
                f.setMime((String)t3.getT3());
            }
            return f;
        }).flatMap(arg_0 -> ((FileService)this).put(arg_0)).flatMap(f -> this.load(f.key()));
    }

    public Mono<File> download(FileFilter filter) {
        filter.setPager(new Pager(Integer.valueOf(2)));
        if (filter.getFetchBody() == null) {
            filter.setFetchBody(Boolean.valueOf(true));
        }
        return this.find(filter).singleOrEmpty().onErrorMap(IndexOutOfBoundsException.class, e -> new IllegalArgumentException("ambiguous filter, more than one file record matches"));
    }
}

