/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.change.ChangeFilter;
import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.info.InfoFilter;
import inc.yukawa.chain.base.core.domain.media.Image;
import inc.yukawa.chain.base.core.domain.media.ImageFilter;
import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;
import org.springframework.stereotype.Repository;

@Repository
public class ImageReadDao
extends HibernateReactiveReadDao<Integer, Image, ImageFilter> {
    public ImageReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected void withFetch(CriteriaQuery<?> query, Root<Image> root, ImageFilter filter) {
        if (filter.getFetchBody() != null) {
            switch (filter.getFetchBody()) {
                case SMALL: {
                    root.fetch("thumbnailSmall");
                    break;
                }
                case MEDIUM: {
                    root.fetch("thumbnailMedium");
                    break;
                }
                case LARGE: {
                    root.fetch("thumbnailLarge");
                    break;
                }
                default: {
                    root.fetch("image");
                }
            }
        }
    }

    protected List<Predicate> withPredicates(ImageFilter filter, Root<Image> root, CriteriaBuilder cb) {
        ChangeFilter changeFilter;
        ChangeFilter createdFilter;
        InfoFilter infoFilter;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("imageId"), () -> ((ImageFilter)filter).getImageId());
        this.whereIn(predicates, cb, (Expression)root.get("imageId"), () -> ((ImageFilter)filter).getImageIds());
        this.whereEquals(predicates, cb, (Expression)root.get("mime"), () -> ((ImageFilter)filter).getMime());
        this.whereEquals(predicates, cb, (Expression)root.get("category"), () -> ((ImageFilter)filter).getCategory());
        this.whereEquals(predicates, cb, (Expression)root.get("position"), () -> ((ImageFilter)filter).getPosition());
        ChainKey relatedFilter = filter.getRelated();
        if (relatedFilter != null) {
            Path relatedPath = root.get("related");
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("module"), () -> ((ChainKey)relatedFilter).getModule());
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("entity"), () -> ((ChainKey)relatedFilter).getEntity());
            this.whereEquals(predicates, cb, (Expression)relatedPath.get("id"), () -> ((ChainKey)relatedFilter).getId());
            this.whereIn(predicates, cb, (Expression)relatedPath.get("id"), () -> ((ImageFilter)filter).getRelatedIds());
        }
        if ((infoFilter = filter.getInfo()) != null) {
            Path infoPath = root.get("info");
            this.whereEquals(predicates, cb, (Expression)infoPath.get("id"), () -> ((InfoFilter)infoFilter).getId());
            this.whereEquals(predicates, cb, (Expression)infoPath.get("name"), () -> ((InfoFilter)infoFilter).getName());
            this.whereEquals(predicates, cb, (Expression)infoPath.get("shortName"), () -> ((InfoFilter)infoFilter).getShortName());
            this.whereLike(predicates, cb, (Expression)infoPath.get("desc"), () -> ((InfoFilter)infoFilter).getDesc());
        }
        if ((createdFilter = filter.getCreated()) != null) {
            Path createdPath = root.get("created");
            this.whereEquals(predicates, cb, (Expression)createdPath.get("user"), () -> ((ChangeFilter)createdFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)createdPath.get("date"), () -> ((ChangeFilter)createdFilter).getDate());
        }
        if ((changeFilter = filter.getChange()) != null) {
            Path changePath = root.get("change");
            this.whereEquals(predicates, cb, (Expression)changePath.get("user"), () -> ((ChangeFilter)changeFilter).getUser());
            this.whereBetween(predicates, cb, (Expression)changePath.get("date"), () -> ((ChangeFilter)changeFilter).getDate());
        }
        return predicates;
    }
}

