/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.media.Image;
import inc.yukawa.chain.base.core.domain.media.ImageBody;
import inc.yukawa.chain.base.core.domain.media.ImageFilter;
import inc.yukawa.chain.base.core.domain.media.ImageSize;
import inc.yukawa.chain.base.core.domain.media.MediaBase;
import inc.yukawa.chain.base.core.filter.Pager;
import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.media.ThumbnailService;
import inc.yukawa.chain.base.media.domain.ThumbDefault;
import inc.yukawa.chain.base.media.domain.ThumbLarge;
import inc.yukawa.chain.base.media.domain.ThumbMedium;
import inc.yukawa.chain.base.media.domain.ThumbSmall;
import inc.yukawa.chain.base.service.InterceptedRepoAspect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Service
@Validated
public class ImageService
extends InterceptedRepoAspect<Integer, Image, ImageFilter> {
    private final ThumbnailService thumbnailService;
    @Value(value="${chain.media.image.downloadUrlPrefix:/image/download}")
    private String imageDownloadUrlPrefix;

    public ImageService(JpaRepo<Integer, Image, ImageFilter> repo, ThumbnailService thumbnailService) {
        super(repo);
        this.thumbnailService = thumbnailService;
    }

    public Mono<Map<String, List<String>>> getUrls(ChainKey chainKey) {
        Assert.hasText((String)chainKey.getModule(), (String)"module");
        Assert.hasText((String)chainKey.getEntity(), (String)"entity");
        Assert.hasText((String)chainKey.getId(), (String)"id");
        ImageFilter filter = new ImageFilter();
        filter.setRelated(chainKey);
        return this.find(filter).collectList().map(this::asUrlsMap).map(r -> r.getOrDefault(chainKey, new HashMap()));
    }

    public Mono<Map<ChainKey, Map<String, List<String>>>> getUrls(String module, String entity, Set<String> ids) {
        Assert.hasText((String)module, (String)"module");
        Assert.hasText((String)entity, (String)"entity");
        Assert.isTrue((ids != null && !ids.isEmpty() ? 1 : 0) != 0, (String)"ids empty");
        ImageFilter filter = new ImageFilter();
        filter.setRelated(new ChainKey(module, entity, null));
        filter.setRelatedIds(ids);
        return this.find(filter).collectList().map(this::asUrlsMap);
    }

    public Mono<Image> saveImage(Image image, Mono<FilePart> file) {
        return file.flatMap(this.thumbnailService::toThumbnails).zipWith(this.put((Keyed)image), (t4, img) -> {
            img.setImage((ImageBody)new ThumbDefault(img.getImageId(), (byte[])t4.getT1()));
            img.setThumbnailLarge((ImageBody)new ThumbLarge(img.getImageId(), (byte[])t4.getT2()));
            img.setThumbnailMedium((ImageBody)new ThumbMedium(img.getImageId(), (byte[])t4.getT3()));
            img.setThumbnailSmall((ImageBody)new ThumbSmall(img.getImageId(), (byte[])t4.getT4()));
            return img;
        }).flatMap(arg_0 -> ((ImageService)this).put(arg_0)).flatMap(img -> this.load(img.key()));
    }

    public Mono<Image> saveMainImage(ChainKey related, Mono<FilePart> file) {
        return this.replaceImage(related, "main", 0, file);
    }

    public Mono<Image> replaceImage(ChainKey related, String category, Integer position, Mono<FilePart> file) {
        Assert.notNull((Object)related, (String)"related");
        Assert.notNull((Object)related.getEntity(), (String)"related.entity");
        Assert.notNull((Object)related.getId(), (String)"related.id");
        Assert.notNull((Object)category, (String)"category");
        ImageFilter f = new ImageFilter();
        f.setRelated(related);
        f.setCategory(category);
        f.setPosition(position);
        Image image = new Image();
        image.setCategory(category);
        image.setRelated(related);
        image.setPosition(position);
        return this.findKeys(f).singleOrEmpty().flatMap(arg_0 -> ((ImageService)this).deleteByKey(arg_0)).thenReturn((Object)image).flatMap(i -> this.saveImage((Image)i, file));
    }

    public Mono<Image> appendAdditionalImage(ChainKey related, Mono<FilePart> file) {
        return this.appendImage(related, "additional", file);
    }

    public Mono<Image> appendImage(ChainKey related, String category, Mono<FilePart> file) {
        Assert.hasText((String)category, (String)"category");
        Assert.notNull((Object)related, (String)"related");
        Assert.notNull((Object)related.getEntity(), (String)"related.entity");
        Assert.notNull((Object)related.getId(), (String)"related.id");
        ImageFilter f = new ImageFilter();
        f.setRelated(related);
        f.setCategory(category);
        Image image = new Image();
        image.setCategory(category);
        image.setRelated(related);
        return this.find(f).collectList().map(l -> l.stream().filter(i -> i.getPosition() != null).mapToInt(MediaBase::getPosition).max().orElse(0)).map(lastPos -> {
            image.setPosition(Integer.valueOf(lastPos + 1));
            return image;
        }).flatMap(pos -> this.saveImage(image, file));
    }

    public Mono<Tuple2<ImageBody, Date>> download(ImageFilter filter) {
        filter.setPager(new Pager(Integer.valueOf(2)));
        if (filter.getFetchBody() == null) {
            filter.setFetchBody(ImageSize.DEFAULT);
        }
        return this.find(filter).singleOrEmpty().onErrorMap(IndexOutOfBoundsException.class, e -> new IllegalArgumentException("ambiguous filter, more than one image record matches")).map(image -> {
            Date lastModified = image.getChange() != null && image.getChange().getDate() != null ? image.getChange().getDate() : new Date();
            switch (filter.getFetchBody()) {
                case LARGE: {
                    return Tuples.of((Object)image.getThumbnailLarge(), (Object)lastModified);
                }
                case MEDIUM: {
                    return Tuples.of((Object)image.getThumbnailMedium(), (Object)lastModified);
                }
                case SMALL: {
                    return Tuples.of((Object)image.getThumbnailSmall(), (Object)lastModified);
                }
            }
            return Tuples.of((Object)image.getImage(), (Object)lastModified);
        }).filter(t2 -> ((ImageBody)t2.getT1()).getData() != null);
    }

    private Map<ChainKey, Map<String, List<String>>> asUrlsMap(List<Image> images) {
        HashMap<ChainKey, Map<String, List<String>>> res = new HashMap<ChainKey, Map<String, List<String>>>();
        images.stream().sorted(Comparator.comparingInt(i -> i.getPosition() != null ? i.getPosition() : 0)).forEach(image -> {
            Map urls = res.computeIfAbsent(image.getRelated(), chainKey -> new HashMap());
            List categoryToUrls = urls.computeIfAbsent(image.getCategory() == null ? "main" : image.getCategory(), cat -> new ArrayList());
            categoryToUrls.add(this.asUrl((Image)image));
        });
        return res;
    }

    private String asUrl(Image image) {
        return UriComponentsBuilder.newInstance().path(this.imageDownloadUrlPrefix).queryParam("imageId", new Object[]{image.getImageId()}).build().toUriString();
    }
}

