/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Duration;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

@Service
public class UploadService {
    private static final Logger LOG = LoggerFactory.getLogger(UploadService.class);
    private final Tika tika = new Tika();
    @Value(value="${chain.media.file.upload.timeout:PT60S}")
    private Duration uploadTimeout;

    public Mono<Tuple3<byte[], String, String>> toBody(FilePart filePart) {
        return Mono.fromCallable(() -> {
            LOG.trace("Buffering upload");
            PipedInputStream input = UploadService.pipe(filePart, this.uploadTimeout);
            byte[] data = IOUtils.toByteArray((InputStream)input);
            String mediaType = this.tika.detect(data, filePart.filename());
            return Tuples.of((Object)data, (Object)filePart.filename(), (Object)mediaType);
        }).timeout(this.uploadTimeout).subscribeOn(Schedulers.elastic());
    }

    public static PipedInputStream pipe(FilePart filePart, Duration timeout) {
        return UploadService.pipe(filePart, new PipedOutputStream(), timeout);
    }

    public static PipedInputStream pipe(FilePart filePart, PipedOutputStream osPipe, Duration timeout) {
        try {
            PipedInputStream isPipe = new PipedInputStream(osPipe, 102400);
            UploadService.streamFile(filePart, osPipe, timeout);
            return isPipe;
        }
        catch (IOException e) {
            LOG.error("IOException while chaining file: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static void streamFile(FilePart filePart, OutputStream os, Duration timeout) {
        DataBufferUtils.write((Publisher)filePart.content().doOnNext(b -> LOG.trace("Consuming buffer: {}", (Object)b.readableByteCount())), (OutputStream)os).timeout(timeout).doOnTerminate(() -> {
            LOG.trace("Closing PipedOutputStream");
            IOUtils.closeQuietly((OutputStream)os);
        }).subscribeOn(Schedulers.elastic()).subscribe(b -> {
            LOG.trace("read chunk of {} bytes", (Object)b.readableByteCount());
            DataBufferUtils.releaseConsumer().accept(b);
        });
    }
}

