/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import inc.yukawa.chain.base.core.domain.entity.ChainKey;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.media.File;
import inc.yukawa.chain.base.core.domain.media.FileFilter;
import inc.yukawa.chain.base.media.FileService;
import inc.yukawa.chain.base.rest.ctrl.RepoAspectRest;
import inc.yukawa.chain.base.service.RepoAspect;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Tag(name="File")
@RestController
@RequestMapping(path={"/file"}, produces={"application/json", "text/xml"})
@Validated
public class FileRest
extends RepoAspectRest<Integer, File, FileFilter> {
    private static final Logger LOG = LoggerFactory.getLogger(FileRest.class);
    private final Tika tika = new Tika();

    public FileRest(FileService aspect) {
        super((RepoAspect)aspect);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @Operation(summary="upload", description="Upload a new file and associated metadata")
    public Mono<File> upload(@RequestPart(value="file", required=false) File file, @RequestPart(value="body") Mono<FilePart> body) {
        LOG.info("[{}] upload for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)file);
        if (file == null) {
            file = new File();
        }
        return ((FileService)this.aspect).saveFile(file, body);
    }

    @PostMapping(value={"/uploadFile"}, consumes={"multipart/form-data"})
    @Operation(summary="uploadFile", description="Upload a new file and associated metadata")
    public Mono<File> uploadFile(@RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="shortName", required=false) String shortName, @RequestParam(value="description", required=false) String description, @RequestParam(value="category", required=false) String category, @RequestParam(value="position", required=false) Integer position, @RequestParam(value="relatedEntity", required=false) String relatedEntity, @RequestParam(value="relatedModule", required=false) String relatedModule, @RequestParam(value="relatedId", required=false) String relatedId, @RequestPart(value="body") Mono<FilePart> body) {
        File file = new File();
        file.setInfo(new Info(fileName, shortName, description));
        file.setCategory(category);
        file.setPosition(position);
        file.setRelated(new ChainKey());
        file.getRelated().setEntity(relatedEntity);
        file.getRelated().setModule(relatedModule);
        file.getRelated().setId(relatedId);
        return this.upload(file, body);
    }

    @PostMapping(value={"/download"}, produces={"*/*"})
    @Operation(summary="download")
    public Mono<ResponseEntity<Resource>> download(@RequestBody FileFilter filter) {
        LOG.info("[{}] download for: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)filter);
        return ((FileService)this.aspect).download(filter).map(file -> {
            if (file.getBody() == null || file.getBody().getData() == null) {
                return ResponseEntity.noContent().build();
            }
            String fileName = Optional.ofNullable(file.getInfo()).map(Info::getName).orElse("" + file.getFileId());
            String mime = file.getMime();
            if (mime == null) {
                mime = this.tika.detect(file.getBody().getData(), fileName);
            }
            MediaType mediaType = MediaType.parseMediaType((String)mime);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + fileName})).contentType(mediaType).body((Object)new ByteArrayResource(file.getBody().getData()));
        }).switchIfEmpty(Mono.just((Object)ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/download"}, produces={"*/*"})
    @Operation(summary="download")
    public Mono<ResponseEntity<Resource>> download(@RequestParam(value="fileId", required=false) Integer fileId, @RequestParam(value="relatedModule", required=false) String relatedModule, @RequestParam(value="relatedEntity", required=false) String relatedEntity, @RequestParam(value="relatedId", required=false) String relatedId, @RequestParam(value="category", required=false) String category, @RequestParam(value="position", required=false) Integer position) {
        FileFilter f = new FileFilter();
        f.setFileId(fileId);
        if (relatedModule != null || relatedEntity != null || relatedId != null) {
            f.setRelated(new ChainKey(relatedModule, relatedEntity, relatedId));
        }
        f.setCategory(category);
        f.setPosition(position);
        return this.download(f);
    }
}

