/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.media;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

@Service
public class ThumbnailService {
    private static final Logger LOG = LoggerFactory.getLogger(ThumbnailService.class);
    @Value(value="${chain.media.thumbnail.default.width:1920}")
    private int defaultWidth;
    @Value(value="${chain.media.thumbnail.default.height:1080}")
    private int defaultHeight;
    @Value(value="${chain.media.thumbnail.large.width:1280}")
    private int largeWidth;
    @Value(value="${chain.media.thumbnail.large.height:960}")
    private int largeHeight;
    @Value(value="${chain.media.thumbnail.medium.width:640}")
    private int mediumWidth;
    @Value(value="${chain.media.thumbnail.medium.height:480}")
    private int mediumHeight;
    @Value(value="${chain.media.thumbnail.small.width:320}")
    private int smallWidth;
    @Value(value="${chain.media.thumbnail.small.height:240}")
    private int smallHeight;
    @Value(value="${chain.media.thumbnail.default.outputQuality:#{null}}")
    private Float outputQuality;
    @Value(value="${chain.media.thumbnail.default.outputFormat:jpg}")
    private String outputFormat;
    @Value(value="${chain.media.thumbnail.upload.timeout:PT30S}")
    private Duration uploadTimeout;

    public Mono<Tuple4<byte[], byte[], byte[], byte[]>> toThumbnails(FilePart filePart) {
        return this.newTmpFile().flatMap(tmpFile -> filePart.transferTo(tmpFile).then(Mono.fromCallable(() -> {
            LOG.trace("Generating thumbnails from {}", tmpFile);
            File f = tmpFile.toFile();
            f.deleteOnExit();
            try {
                byte[] def = this.doThumbnail(f, this.defaultWidth, this.defaultHeight, this.outputFormat, this.outputQuality);
                byte[] large = this.doThumbnail(f, this.largeWidth, this.largeHeight, this.outputFormat, this.outputQuality);
                byte[] medium = this.doThumbnail(f, this.mediumWidth, this.mediumHeight, this.outputFormat, this.outputQuality);
                byte[] small = this.doThumbnail(f, this.smallWidth, this.smallHeight, this.outputFormat, this.outputQuality);
                return Tuples.of((Object)def, (Object)large, (Object)medium, (Object)small);
            }
            catch (IOException e) {
                LOG.error("Failed to generate thumbnail", (Throwable)e);
                throw new IllegalStateException(e);
            }
        })).doFinally(s -> {
            try {
                Files.deleteIfExists(tmpFile);
            }
            catch (IOException e) {
                LOG.warn("Consuming IOException while deleting tmp file: ", (Throwable)e);
            }
        })).subscribeOn(Schedulers.boundedElastic()).timeout(this.uploadTimeout).doOnNext(t -> LOG.debug("Generated thumbnails of bytes: [{}, {},{},{}]", new Object[]{((byte[])t.getT1()).length, ((byte[])t.getT2()).length, ((byte[])t.getT3()).length, ((byte[])t.getT4()).length}));
    }

    public Mono<Path> newTmpFile() {
        return Mono.fromCallable(() -> Files.createTempFile("thumbgen-", ".tmp", new FileAttribute[0]));
    }

    private byte[] doThumbnail(File in, int width, int height, String outputFormat, Float outputQuality) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Thumbnails.Builder builder = Thumbnails.of((File[])new File[]{in}).size(width, height);
        if (outputFormat != null) {
            builder.outputFormat(outputFormat);
        }
        if (outputQuality != null) {
            builder.outputQuality(outputQuality.floatValue());
        }
        builder.toOutputStream((OutputStream)result);
        return result.toByteArray();
    }
}

