/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.mono.repos;

import com.fasterxml.jackson.core.type.TypeReference;
import inc.yukawa.chain.base.core.domain.info.HostStoreInfo;
import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.core.domain.result.ResultDetail;
import inc.yukawa.chain.base.mono.dao.MonoDao;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.MonoRepository;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CompositeRepos<K, V, F>
implements MonoRepository<K, V, F> {
    protected final MonoLoadDao<K, V> loadDao;
    protected final MonoReadDao<K, V, F> readDao;
    protected final MonoWriteDao<K, V> writeDao;
    private final TypeReference<V> type = new TypeReference<V>(){};

    public CompositeRepos(MonoDao<K, V, F> dao) {
        this(dao, dao, dao);
    }

    public CompositeRepos(MonoLoadDao<K, V> loadDao, MonoReadDao<K, V, F> readDao, MonoWriteDao<K, V> writeDao) {
        this.loadDao = loadDao;
        this.readDao = readDao;
        this.writeDao = writeDao;
    }

    public CompositeRepos(MonoReadDao<K, V, F> readDao, MonoWriteDao<K, V> writeDao) {
        this(readDao, readDao, writeDao);
    }

    @Override
    public Mono<V> load(K key) {
        Objects.requireNonNull(key, "key");
        return this.loadDao.load(key);
    }

    @Override
    public Mono<V> read(F filter) {
        return this.readDao.read(filter);
    }

    @Override
    public Mono<Long> count(F filter) {
        return this.readDao.count(filter);
    }

    @Override
    public Mono<Map<K, V>> map(F filter) {
        return this.readDao.map(filter);
    }

    @Override
    public Flux<V> find(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.find(filter);
    }

    @Override
    public Mono<QueryResult<V>> query(F filter) {
        Objects.requireNonNull(filter, "filter");
        return this.readDao.query(filter);
    }

    @Override
    public Mono<V> put(K key, V value) {
        return this.writeDao.put(key, value);
    }

    @Override
    public Mono<Integer> deleteKey(K key) {
        return this.writeDao.deleteKey(key);
    }

    @Override
    public Mono<EditResult> edit(V value) {
        throw new UnsupportedOperationException("CompositeRepos.edit not implemented");
    }

    @Override
    public Mono<EditResult> edit(K key, V value) {
        if (value == null) {
            return this.removeKey(key);
        }
        return this.writeDao.put(key, value).map(integer -> new EditResult("edit", key.getClass(), String.valueOf(key)));
    }

    @Override
    public Mono<EditResult> removeAll(F filter) {
        EditResult result = new EditResult("removeAll", this.getValueFqn(), filter.toString());
        return this.readDao.findKeys(filter).flatMap(k -> this.removeKey(k)).collectList().map(delResults -> {
            delResults.forEach(arg_0 -> ((EditResult)result).merge(arg_0));
            return result;
        });
    }

    @Override
    public Mono<EditResult> removeKey(K key) {
        Objects.requireNonNull(key, "key");
        return this.writeDao.deleteKey(key).map(count -> new EditResult("deleteKey", key.getClass(), String.valueOf(key), count == 0 ? ResultDetail.warn((String)("" + key), (String)"NOT_FOUND", (String)this.getClass().getSimpleName()) : ResultDetail.info((String)("" + key), (String)"DELETE", (String)this.getClass().getSimpleName())));
    }

    protected String getValueFqn() {
        return this.type.getType().getTypeName();
    }

    @Override
    public Flux<HostStoreInfo> meta() {
        throw new UnsupportedOperationException("CompositeRepos.meta not implemented");
    }
}

