/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.mono.dao;

import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MonoReadDao<K, V, F>
extends MonoLoadDao<K, V> {
    default public Flux<V> find(F filter) {
        return this.map(filter).flatMapMany(m -> Flux.fromIterable(m.values()));
    }

    default public Flux<K> findKeys(F filter) {
        return this.map(filter).flatMapMany(m -> Flux.fromIterable(m.keySet()));
    }

    default public Mono<QueryResult<V>> query(F filter) {
        return this.find(filter).collectList().map(QueryResult::new);
    }

    default public Mono<V> read(F filter) {
        return this.find(filter).singleOrEmpty();
    }

    default public Mono<Long> count(F filter) {
        return this.find(filter).count();
    }

    default public Mono<Map<K, V>> map(F filter) {
        throw new UnsupportedOperationException("MonoReadDao.map: @toDo");
    }
}

