/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.domain;

import inc.yukawa.chain.base.payment.stripe.domain.PaymentMethod;

public class CardPaymentMethod
extends PaymentMethod {
    private String brand;
    private String lastDigits;
    private String expiryMonth;
    private String expiryYear;

    protected CardPaymentMethod(CardPaymentMethodBuilder<?, ?> b) {
        super(b);
        this.brand = b.brand;
        this.lastDigits = b.lastDigits;
        this.expiryMonth = b.expiryMonth;
        this.expiryYear = b.expiryYear;
    }

    public static CardPaymentMethodBuilder<?, ?> builder() {
        return new CardPaymentMethodBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardPaymentMethod)) {
            return false;
        }
        CardPaymentMethod other = (CardPaymentMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$lastDigits = this.getLastDigits();
        String other$lastDigits = other.getLastDigits();
        if (this$lastDigits == null ? other$lastDigits != null : !this$lastDigits.equals(other$lastDigits)) {
            return false;
        }
        String this$expiryMonth = this.getExpiryMonth();
        String other$expiryMonth = other.getExpiryMonth();
        if (this$expiryMonth == null ? other$expiryMonth != null : !this$expiryMonth.equals(other$expiryMonth)) {
            return false;
        }
        String this$expiryYear = this.getExpiryYear();
        String other$expiryYear = other.getExpiryYear();
        return !(this$expiryYear == null ? other$expiryYear != null : !this$expiryYear.equals(other$expiryYear));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CardPaymentMethod;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $lastDigits = this.getLastDigits();
        result = result * 59 + ($lastDigits == null ? 43 : $lastDigits.hashCode());
        String $expiryMonth = this.getExpiryMonth();
        result = result * 59 + ($expiryMonth == null ? 43 : $expiryMonth.hashCode());
        String $expiryYear = this.getExpiryYear();
        result = result * 59 + ($expiryYear == null ? 43 : $expiryYear.hashCode());
        return result;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getLastDigits() {
        return this.lastDigits;
    }

    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    @Override
    public String toString() {
        return "CardPaymentMethod(brand=" + this.getBrand() + ", lastDigits=" + this.getLastDigits() + ", expiryMonth=" + this.getExpiryMonth() + ", expiryYear=" + this.getExpiryYear() + ")";
    }

    private static final class CardPaymentMethodBuilderImpl
    extends CardPaymentMethodBuilder<CardPaymentMethod, CardPaymentMethodBuilderImpl> {
        private CardPaymentMethodBuilderImpl() {
        }

        @Override
        protected CardPaymentMethodBuilderImpl self() {
            return this;
        }

        @Override
        public CardPaymentMethod build() {
            return new CardPaymentMethod(this);
        }
    }

    public static abstract class CardPaymentMethodBuilder<C extends CardPaymentMethod, B extends CardPaymentMethodBuilder<C, B>>
    extends PaymentMethod.PaymentMethodBuilder<C, B> {
        private String brand;
        private String lastDigits;
        private String expiryMonth;
        private String expiryYear;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B brand(String brand) {
            this.brand = brand;
            return (B)this.self();
        }

        public B lastDigits(String lastDigits) {
            this.lastDigits = lastDigits;
            return (B)this.self();
        }

        public B expiryMonth(String expiryMonth) {
            this.expiryMonth = expiryMonth;
            return (B)this.self();
        }

        public B expiryYear(String expiryYear) {
            this.expiryYear = expiryYear;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CardPaymentMethod.CardPaymentMethodBuilder(super=" + super.toString() + ", brand=" + this.brand + ", lastDigits=" + this.lastDigits + ", expiryMonth=" + this.expiryMonth + ", expiryYear=" + this.expiryYear + ")";
        }
    }
}

