/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.domain;

public class StripeApiClientConfig {
    private String secretKey;
    private int connectTimeout;
    private int maxRetries;
    private int readTimeout;

    StripeApiClientConfig(String secretKey, int connectTimeout, int maxRetries, int readTimeout) {
        this.secretKey = secretKey;
        this.connectTimeout = connectTimeout;
        this.maxRetries = maxRetries;
        this.readTimeout = readTimeout;
    }

    public static StripeApiClientConfigBuilder builder() {
        return new StripeApiClientConfigBuilder();
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeApiClientConfig)) {
            return false;
        }
        StripeApiClientConfig other = (StripeApiClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        return this.getReadTimeout() == other.getReadTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StripeApiClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getMaxRetries();
        result = result * 59 + this.getReadTimeout();
        return result;
    }

    public String toString() {
        return "StripeApiClientConfig(secretKey=" + this.getSecretKey() + ", connectTimeout=" + this.getConnectTimeout() + ", maxRetries=" + this.getMaxRetries() + ", readTimeout=" + this.getReadTimeout() + ")";
    }

    public static class StripeApiClientConfigBuilder {
        private String secretKey;
        private int connectTimeout;
        private int maxRetries;
        private int readTimeout;

        StripeApiClientConfigBuilder() {
        }

        public StripeApiClientConfigBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public StripeApiClientConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public StripeApiClientConfigBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public StripeApiClientConfigBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public StripeApiClientConfig build() {
            return new StripeApiClientConfig(this.secretKey, this.connectTimeout, this.maxRetries, this.readTimeout);
        }

        public String toString() {
            return "StripeApiClientConfig.StripeApiClientConfigBuilder(secretKey=" + this.secretKey + ", connectTimeout=" + this.connectTimeout + ", maxRetries=" + this.maxRetries + ", readTimeout=" + this.readTimeout + ")";
        }
    }
}

