/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.event;

import inc.yukawa.chain.base.payment.stripe.event.BaseStripeEvent;
import inc.yukawa.chain.base.payment.stripe.event.CustomerEvent;
import inc.yukawa.chain.base.payment.stripe.event.PaymentIntentEvent;
import inc.yukawa.chain.base.payment.stripe.event.SetupIntentEvent;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventMapper;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventPayload;
import inc.yukawa.chain.base.payment.stripe.exception.NoSuchStripeEventException;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class DefaultStripeEventMapper
implements StripeEventMapper {
    private static final Map<String, BaseStripeEvent.Factory> enumMap = new HashMap<String, BaseStripeEvent.Factory>();

    @Override
    public Mono<BaseStripeEvent> getEvent(StripeEventPayload payload) {
        return Mono.fromCallable(() -> DefaultStripeEventMapper.getBaseStripeEvent(payload));
    }

    private static BaseStripeEvent getBaseStripeEvent(StripeEventPayload payload) throws NoSuchStripeEventException {
        BaseStripeEvent.Factory factory = enumMap.get(payload.getType());
        if (factory == null) {
            throw new NoSuchStripeEventException("There is no mapping defined for the stripe event", payload.getType());
        }
        return factory.create(payload.getType(), payload);
    }

    static {
        enumMap.put("payment_intent.created", PaymentIntentEvent::new);
        enumMap.put("payment_intent.payment_failed", PaymentIntentEvent::new);
        enumMap.put("payment_intent.succeeded", PaymentIntentEvent::new);
        enumMap.put("setup_intent.created", SetupIntentEvent::new);
        enumMap.put("setup_intent.succeeded", SetupIntentEvent::new);
        enumMap.put("customer.created", CustomerEvent::new);
    }
}

