/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.event;

import inc.yukawa.chain.base.payment.stripe.event.BaseStripeEvent;
import inc.yukawa.chain.base.payment.stripe.event.StripeEventPayload;
import inc.yukawa.chain.base.payment.stripe.exception.OrderIdNotFoundException;
import reactor.core.publisher.Mono;

public class PaymentIntentEvent
implements BaseStripeEvent {
    private final String value;
    private final StripeEventPayload payload;

    PaymentIntentEvent(String value, StripeEventPayload payload) {
        this.value = value;
        this.payload = payload;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public StripeEventPayload getPayload() {
        return this.payload;
    }

    public Integer getOrderId() throws OrderIdNotFoundException {
        String orderId = this.getMetadata().get("orderId");
        if (orderId == null) {
            throw new OrderIdNotFoundException("OrderId is missing in metadata", this.value);
        }
        return Integer.valueOf(orderId);
    }

    public Mono<Integer> getOrderIdMono() {
        return Mono.fromCallable(this::getOrderId);
    }
}

