/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.client;

import com.stripe.model.Customer;
import com.stripe.model.PaymentIntent;
import com.stripe.model.SetupIntent;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryResponseMapper;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.StripeCustomer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Supplier;

public class BaseStripeLibraryResponseMapper<PRE extends PaymentIntentResponse, SRE extends SetupIntentResponse, SC extends StripeCustomer>
implements StripeLibraryResponseMapper<PRE, SRE, SC> {
    private final Supplier<SRE> setupIntentResponseSupplier;
    private final Supplier<PRE> paymentIntentResponseSupplier;
    private final Supplier<SC> stripeCustomerSupplier;

    public BaseStripeLibraryResponseMapper(Supplier<SRE> setupIntentResponseSupplier, Supplier<PRE> paymentIntentResponseSupplier, Supplier<SC> stripeCustomerSupplier) {
        this.setupIntentResponseSupplier = setupIntentResponseSupplier;
        this.paymentIntentResponseSupplier = paymentIntentResponseSupplier;
        this.stripeCustomerSupplier = stripeCustomerSupplier;
    }

    @Override
    public PRE mapPaymentIntentResponse(PaymentIntent apiResponse) {
        PaymentIntentResponse response = (PaymentIntentResponse)this.paymentIntentResponseSupplier.get();
        response.setStripeStatus(apiResponse.getStatus());
        response.setClientSecret(response.getClientSecret());
        response.setStripeUserId(apiResponse.getCustomer());
        response.setCurrency(response.getCurrency());
        response.setAmount(BaseStripeLibraryResponseMapper.amountToBigDecimal(apiResponse.getAmount()));
        response.setPaymentIntentId(apiResponse.getId());
        return (PRE)response;
    }

    @Override
    public SRE mapSetupIntentResponse(SetupIntent apiResponse) {
        SetupIntentResponse response = (SetupIntentResponse)this.setupIntentResponseSupplier.get();
        response.setClientSecret(apiResponse.getClientSecret());
        response.setStripeUserId(apiResponse.getCustomer());
        response.setSetupIntentId(apiResponse.getId());
        return (SRE)response;
    }

    @Override
    public SC mapStripeCustomer(Customer customer) {
        StripeCustomer response = (StripeCustomer)this.stripeCustomerSupplier.get();
        response.setId(customer.getId());
        response.setName(customer.getName());
        return (SC)response;
    }

    private static BigDecimal amountToBigDecimal(Long amount) {
        return new BigDecimal(amount).setScale(2, RoundingMode.UNNECESSARY).divide(BigDecimal.valueOf(100L), RoundingMode.UNNECESSARY);
    }
}

