/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.client;

import inc.yukawa.chain.base.payment.stripe.client.ReactiveStripeClient;
import inc.yukawa.chain.base.payment.stripe.client.StripeClient;
import inc.yukawa.chain.base.payment.stripe.domain.CreateTransferRequest;
import inc.yukawa.chain.base.payment.stripe.domain.CreateTransferResponse;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentMethods;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.StripeAccount;
import inc.yukawa.chain.base.payment.stripe.domain.StripeCustomer;
import java.util.List;
import reactor.core.publisher.Mono;

public class ReactiveStripeClientImpl<PR extends PaymentIntentRequest, PRE extends PaymentIntentResponse, SR extends SetupIntentRequest, SRE extends SetupIntentResponse, SC extends StripeCustomer>
implements ReactiveStripeClient<PR, PRE, SR, SRE, SC> {
    private final StripeClient<PR, PRE, SR, SRE, SC> stripeClient;

    public ReactiveStripeClientImpl(StripeClient<PR, PRE, SR, SRE, SC> stripeClient) {
        this.stripeClient = stripeClient;
    }

    @Override
    public Mono<SC> getCustomerByName(String userName) {
        return Mono.fromCallable(() -> this.stripeClient.getCustomerByName(userName));
    }

    @Override
    public Mono<SC> createCustomer(String userName) {
        return Mono.fromCallable(() -> this.stripeClient.createCustomer(userName));
    }

    @Override
    public Mono<SC> getCustomerById(String stripeUserId) {
        return Mono.fromCallable(() -> this.stripeClient.getCustomerById(stripeUserId));
    }

    @Override
    public Mono<PRE> createPaymentIntent(PR paymentIntentRequest) {
        return Mono.fromCallable(() -> this.stripeClient.createPaymentIntent((PaymentIntentRequest)paymentIntentRequest));
    }

    @Override
    public Mono<SRE> createSetupIntent(SR setupIntentRequest) {
        return Mono.fromCallable(() -> this.stripeClient.createSetupIntent((SetupIntentRequest)setupIntentRequest));
    }

    @Override
    public Mono<PaymentMethods> getPaymentMethods(String stripeUserId) {
        return Mono.fromCallable(() -> this.stripeClient.getPaymentMethods(stripeUserId));
    }

    @Override
    public Mono<Void> deletePaymentMethod(String paymentMethodId) {
        return Mono.fromCallable(() -> {
            this.stripeClient.deletePaymentMethod(paymentMethodId);
            return null;
        });
    }

    @Override
    public Mono<List<StripeAccount>> getConnectedAccounts() {
        return Mono.fromCallable(this.stripeClient::getConnectedAccounts);
    }

    @Override
    public Mono<CreateTransferResponse> createTransfer(CreateTransferRequest request) {
        return Mono.fromCallable(() -> this.stripeClient.createTransfer(request));
    }
}

