/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.base.payment.stripe.config;

import com.stripe.Stripe;
import inc.yukawa.chain.base.payment.stripe.client.BaseStripeLibraryRequestMapper;
import inc.yukawa.chain.base.payment.stripe.client.BaseStripeLibraryResponseMapper;
import inc.yukawa.chain.base.payment.stripe.client.ReactiveStripeClient;
import inc.yukawa.chain.base.payment.stripe.client.ReactiveStripeClientImpl;
import inc.yukawa.chain.base.payment.stripe.client.StripeClient;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryClient;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryRequestMapper;
import inc.yukawa.chain.base.payment.stripe.client.StripeLibraryResponseMapper;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.PaymentIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentRequest;
import inc.yukawa.chain.base.payment.stripe.domain.SetupIntentResponse;
import inc.yukawa.chain.base.payment.stripe.domain.StripeApiClientConfig;
import inc.yukawa.chain.base.payment.stripe.domain.StripeCustomer;
import java.util.function.Supplier;
import org.springframework.context.annotation.Bean;

public abstract class StripeConfigBase<PR extends PaymentIntentRequest, PRE extends PaymentIntentResponse, SR extends SetupIntentRequest, SRE extends SetupIntentResponse, SC extends StripeCustomer> {
    protected final Supplier<SRE> setupIntentResponseSupplier;
    protected final Supplier<PRE> paymentIntentResponseSupplier;
    protected final Supplier<SC> stripeCustomerSupplier;

    public StripeConfigBase(Supplier<SRE> setupIntentResponseSupplier, Supplier<PRE> paymentIntentResponseSupplier, Supplier<SC> stripeCustomerSupplier) {
        this.setupIntentResponseSupplier = setupIntentResponseSupplier;
        this.paymentIntentResponseSupplier = paymentIntentResponseSupplier;
        this.stripeCustomerSupplier = stripeCustomerSupplier;
    }

    @Bean
    public StripeClient<PR, PRE, SR, SRE, SC> baseStripeClient(StripeLibraryResponseMapper<PRE, SRE, SC> responseMapper, StripeLibraryRequestMapper<PR, SR> requestMapper, StripeApiClientConfig apiConfig) {
        Stripe.apiKey = apiConfig.getSecretKey();
        Stripe.setConnectTimeout((int)apiConfig.getConnectTimeout());
        Stripe.setMaxNetworkRetries((int)apiConfig.getMaxRetries());
        Stripe.setReadTimeout((int)apiConfig.getReadTimeout());
        return new StripeLibraryClient<PR, PRE, SR, SRE, SC>(responseMapper, requestMapper);
    }

    @Bean
    public ReactiveStripeClient<PR, PRE, SR, SRE, SC> reactiveStripeClient(StripeClient<PR, PRE, SR, SRE, SC> client) {
        return new ReactiveStripeClientImpl<PR, PRE, SR, SRE, SC>(client);
    }

    @Bean
    public StripeLibraryResponseMapper<PRE, SRE, SC> baseStripeClientResponseMapper() {
        return new BaseStripeLibraryResponseMapper<PRE, SRE, SC>(this.setupIntentResponseSupplier, this.paymentIntentResponseSupplier, this.stripeCustomerSupplier);
    }

    @Bean
    public StripeLibraryRequestMapper<PR, SR> baseStripeClientRequestMapper() {
        return new BaseStripeLibraryRequestMapper();
    }
}

